/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.BernoulliDistribution;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.IntegerDistribution;
import org.eclipse.escet.common.java.Strings;

public class BinomialDistribution
extends IntegerDistribution {
    private final CifRandomGenerator randGen;
    private final double p;
    private final int t;

    public BinomialDistribution(CifRandomGenerator randGen, double p, int t) {
        this.randGen = randGen;
        this.p = p;
        this.t = t;
        if (p < 0.0 || p > 1.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The chance parameter (the first parameter) is not in the range [0.0 .. 1.0].";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        if (t <= 0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The number of experiments (the second parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private BinomialDistribution(BinomialDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.p = distribution.p;
        this.t = distribution.t;
    }

    @Override
    public IntegerDistribution copy() {
        return new BinomialDistribution(this);
    }

    @Override
    public int sample() {
        int count = 0;
        int experiment = 0;
        while (experiment < this.t) {
            if (BernoulliDistribution.sample(this.randGen, this.p)) {
                ++count;
            }
            ++experiment;
        }
        return count;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"binomial(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.p), CifSimulatorMath.intToStr(this.t)});
    }
}

