/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import org.eclipse.escet.common.java.Strings;

public class UncachedUrlClassLoader
extends URLClassLoader {
    public UncachedUrlClassLoader(URL[] urls) throws OpenUrlException {
        super(urls);
        this.initializeConnections(urls);
    }

    public UncachedUrlClassLoader(URL[] urls, ClassLoader parent) throws OpenUrlException {
        super(urls, parent);
        this.initializeConnections(urls);
    }

    private void initializeConnections(URL[] urls) throws OpenUrlException {
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URLConnection connection;
            URL url = uRLArray[n2];
            try {
                connection = url.openConnection();
            }
            catch (IOException ex) {
                throw new OpenUrlException(url, ex);
            }
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            ++n2;
        }
    }

    public static class OpenUrlException
    extends IOException {
        public final URL url;

        public OpenUrlException(URL url, IOException cause) {
            super(cause);
            this.url = url;
        }

        @Override
        public String getMessage() {
            return Strings.fmt("Could not open URL \"%s\".", this.url);
        }
    }
}

