/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement;

import jakarta.validation.Valid;
import jakarta.validation.groups.ConvertGroup;
import jakarta.validation.groups.Default;
import java.time.Year;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.Address;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.BasicPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.Complex;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.ComplexPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.containerelement.PostalSequence;

public class RegisteredAddresses {
    private final Map<Year, List<@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address>> mainAddresses = new HashMap<Year, List<Address>>();
    private final Map<Year, List<Address>> shipmentAddresses = new HashMap<Year, List<Address>>();
    private final Map<Year, List<@Valid @ConvertGroup.List(value={@ConvertGroup(from=Default.class, to=BasicPostal.class), @ConvertGroup(from=Complex.class, to=ComplexPostal.class)}) Address>> preferredShipmentAddresses = new HashMap<Year, List<Address>>();
    private final Map<Year, List<@Valid @ConvertGroup.List(value={@ConvertGroup(from=Default.class, to=BasicPostal.class), @ConvertGroup(from=BasicPostal.class, to=ComplexPostal.class)}) Address>> officeAddresses = new HashMap<Year, List<Address>>();
    private final Map<Year, List<@Valid @ConvertGroup(from=Default.class, to=PostalSequence.class) Address>> weekendAddresses = new HashMap<Year, List<Address>>();

    public RegisteredAddresses() {
    }

    @Valid
    @ConvertGroup(from=Default.class, to=BasicPostal.class)
    public RegisteredAddresses(Map<Year, List<@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address>> mainAddresses) {
        this.mainAddresses.putAll(mainAddresses);
    }

    public RegisteredAddresses addMainAddress(Year year, Address address) {
        this.mainAddresses.computeIfAbsent(year, y -> new ArrayList()).add(address);
        return this;
    }

    public RegisteredAddresses addShipmentAddress(Year year, Address address) {
        this.shipmentAddresses.computeIfAbsent(year, y -> new ArrayList()).add(address);
        return this;
    }

    public RegisteredAddresses addPreferredShipmentAddress(Year year, Address address) {
        this.preferredShipmentAddresses.computeIfAbsent(year, y -> new ArrayList()).add(address);
        return this;
    }

    public RegisteredAddresses addOfficeAddress(Year year, Address address) {
        this.officeAddresses.computeIfAbsent(year, y -> new ArrayList()).add(address);
        return this;
    }

    public RegisteredAddresses addWeekendAddress(Year year, Address address) {
        this.weekendAddresses.computeIfAbsent(year, y -> new ArrayList()).add(address);
        return this;
    }

    public Map<Year, List<Address>> getMainAddresses() {
        return this.mainAddresses;
    }

    public void setMainAddresses(Map<Year, List<@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address>> mainAddresses) {
        this.mainAddresses.clear();
        this.mainAddresses.putAll(mainAddresses);
    }

    public Map<Year, List<Address>> getPreferredShipmentAddresses() {
        return this.preferredShipmentAddresses;
    }

    public Map<Year, List<@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address>> getShipmentAddresses() {
        return this.shipmentAddresses;
    }

    public Map<Year, List<Address>> getOfficeAddresses() {
        return this.officeAddresses;
    }

    public Map<Year, List<Address>> getWeekendAddresses() {
        return this.weekendAddresses;
    }

    public Map<Year, List<@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address>> retrieveMainAddresses() {
        return this.mainAddresses;
    }

    public Map<Year, List<Address>> retrieveWeekendAddresses() {
        return this.weekendAddresses;
    }
}

