/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.server.internal.mongodb.Coll;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStore;

public class Props
extends Coll {
    public static final String NAME = "props";
    public static final String ID = "_id";
    public static final String VALUE = "value";
    public static final String REPOSITORY_CREATED = "org.eclipse.emf.cdo.server.mongodb.repositoryCreated";
    public static final String REPOSITORY_STOPPED = "org.eclipse.emf.cdo.server.mongodb.repositoryStopped";
    public static final String NEXT_LOCAL_CDOID = "org.eclipse.emf.cdo.server.mongodb.nextLocalCDOID";
    public static final String LAST_CDOID = "org.eclipse.emf.cdo.server.mongodb.lastCDOID";
    public static final String LAST_CLASSIFIERID = "org.eclipse.emf.cdo.server.mongodb.lastClassiferID";
    public static final String LAST_BRANCHID = "org.eclipse.emf.cdo.server.mongodb.lastBranchID";
    public static final String LAST_LOCAL_BRANCHID = "org.eclipse.emf.cdo.server.mongodb.lastLocalBranchID";
    public static final String LAST_COMMITTIME = "org.eclipse.emf.cdo.server.mongodb.lastCommitTime";
    public static final String LAST_NONLOCAL_COMMITTIME = "org.eclipse.emf.cdo.server.mongodb.lastNonLocalCommitTime";
    public static final String GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.mongodb.gracefullyShutDown";

    public Props(MongoDBStore store) {
        super(store, NAME);
    }

    public Map<String, String> get(Set<String> names) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : names) {
            BasicDBObject query = new BasicDBObject(ID, (Object)name);
            try (DBCursor cursor = this.collection.find((DBObject)query);){
                if (!cursor.hasNext()) continue;
                DBObject doc = cursor.next();
                result.put(name, (String)doc.get(VALUE));
            }
        }
        return result;
    }

    public void set(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put(ID, (Object)property.getKey());
            doc.put(VALUE, (Object)property.getValue());
            this.collection.save((DBObject)doc);
        }
    }

    public void remove(Set<String> names) {
        BasicDBList list = new BasicDBList();
        for (String name : names) {
            list.add((Object)name);
        }
        BasicDBObject ref = new BasicDBObject();
        ref.put(ID, (Object)new BasicDBObject("$in", (Object)list));
        this.collection.remove((DBObject)ref);
    }
}

