/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.io.PrintWriter;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class AuthenticationServiceBase
implements AuthenticationService,
ModuleControl,
ModuleSupportable,
PropertySetCallback {
    protected UserAuthenticator authenticationScheme;
    private AccessFactory store;
    public static final String AuthenticationTrace = "AuthenticationTrace";
    protected static final int SECMEC_USRSSBPWD = 8;

    protected void setAuthenticationService(UserAuthenticator aScheme) {
        this.authenticationScheme = aScheme;
        SanityManager.ASSERT(this.authenticationScheme != null, "There is no authentication scheme for that service!");
        if (SanityManager.DEBUG_ON(AuthenticationTrace)) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println("Authentication Service: [" + this.toString() + "]");
            iDbgStream.println("Authentication Scheme : [" + this.authenticationScheme.toString() + "]");
        }
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        this.store = (AccessFactory)AuthenticationServiceBase.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        PropertyFactory pf = (PropertyFactory)AuthenticationServiceBase.getServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        if (pf != null) {
            pf.addPropertySetNotification(this);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean authenticate(String databaseName, Properties userInfo) throws SQLException {
        if (userInfo == (Properties)null) {
            return false;
        }
        String userName = userInfo.getProperty("user");
        if (userName != null && userName.length() > 128) {
            return false;
        }
        if (SanityManager.DEBUG_ON(AuthenticationTrace)) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println(" - Authentication request: user [" + userName + "], database [" + databaseName + "]");
        }
        return this.authenticationScheme.authenticateUser(userName, userInfo.getProperty("password"), databaseName, userInfo);
    }

    @Override
    public String getSystemCredentialsDatabaseName() {
        return null;
    }

    public String getProperty(String key) {
        String propertyValue = null;
        TransactionController tc = null;
        try {
            tc = this.getTransaction();
            propertyValue = PropertyUtil.getServiceProperty(tc, key, null);
            if (tc != null) {
                tc.commit();
                tc = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return propertyValue;
    }

    protected TransactionController getTransaction() throws StandardException {
        if (this.store == null) {
            return null;
        }
        return this.store.getTransaction(AuthenticationServiceBase.getContextService().getCurrentContextManager());
    }

    Properties getDatabaseProperties() throws StandardException {
        Properties props = null;
        TransactionController tc = this.getTransaction();
        if (tc != null) {
            try {
                props = tc.getProperties();
            }
            finally {
                tc.commit();
            }
        }
        return props;
    }

    protected String getServiceName() {
        if (this.store == null) {
            return null;
        }
        return AuthenticationServiceBase.getServiceName(this.store);
    }

    public String getDatabaseProperty(String key) {
        String propertyValue = null;
        TransactionController tc = null;
        try {
            if (this.store != null) {
                tc = this.store.getTransaction(AuthenticationServiceBase.getContextService().getCurrentContextManager());
            }
            propertyValue = PropertyUtil.getDatabaseProperty(tc, key);
            if (tc != null) {
                tc.commit();
                tc = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return propertyValue;
    }

    public String getSystemProperty(String key) {
        boolean dbOnly = false;
        dbOnly = Boolean.valueOf(this.getDatabaseProperty("derby.database.propertiesOnly"));
        if (dbOnly) {
            return null;
        }
        return PropertyUtil.getSystemProperty(key);
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.startsWith("derby.user.")) {
            return true;
        }
        String stringValue = (String)((Object)value);
        boolean settingToNativeLocal = "NATIVE::LOCAL".equals(stringValue);
        if ("derby.authentication.provider".equals(key)) {
            String dbo;
            DataDictionary dd;
            UserDescriptor userCredentials;
            if (stringValue != null && stringValue.startsWith("NATIVE:") && !settingToNativeLocal) {
                throw StandardException.newException("XCY05.S.3", new Object[0]);
            }
            String oldValue = (String)p.get("derby.authentication.provider");
            if (oldValue != null && oldValue.startsWith("NATIVE:")) {
                throw StandardException.newException("XCY05.S.2", new Object[0]);
            }
            if (settingToNativeLocal && (userCredentials = (dd = AuthenticationServiceBase.getDataDictionary()).getUser(dbo = dd.getAuthorizationDatabaseOwner())) == null) {
                throw StandardException.newException("XCY05.S.3", new Object[0]);
            }
        }
        if ("derby.authentication.native.passwordLifetimeMillis".equals(key) && this.parsePasswordLifetime(stringValue) == null) {
            throw StandardException.newException("4251J", "derby.authentication.native.passwordLifetimeMillis");
        }
        if ("derby.authentication.native.passwordLifetimeThreshold".equals(key) && this.parsePasswordThreshold(stringValue) == null) {
            throw StandardException.newException("4251J", "derby.authentication.native.passwordLifetimeThreshold");
        }
        return false;
    }

    protected Long parsePasswordLifetime(String passwordLifetimeString) {
        try {
            long passwordLifetime = Long.parseLong(passwordLifetimeString);
            if (passwordLifetime < 0L) {
                passwordLifetime = 0L;
            }
            return passwordLifetime;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Double parsePasswordThreshold(String expirationThresholdString) {
        try {
            double expirationThreshold = Double.parseDouble(expirationThresholdString);
            if (expirationThreshold <= 0.0) {
                return null;
            }
            return expirationThreshold;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) {
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.startsWith("derby.user.")) {
            return null;
        }
        String authService = (String)p.get("derby.authentication.provider");
        if (authService != null && StringUtil.SQLEqualsIgnoreCase(authService, "LDAP")) {
            return null;
        }
        String userPassword = (String)((Object)value);
        if (userPassword != null) {
            String userName = key.substring("derby.user.".length());
            userPassword = this.hashUsingDefaultAlgorithm(userName, userPassword, p);
        }
        return userPassword;
    }

    protected final boolean requireAuthentication(Properties properties) {
        String requireAuthentication = PropertyUtil.getPropertyFromSet(properties, "derby.connection.requireAuthentication");
        if (Boolean.valueOf(requireAuthentication).booleanValue()) {
            return true;
        }
        return PropertyUtil.nativeAuthenticationEnabled(properties);
    }

    protected String hashPasswordSHA1Scheme(String plainTxtUserPassword) {
        if (plainTxtUserPassword == null) {
            return null;
        }
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        algorithm.reset();
        byte[] bytePasswd = null;
        bytePasswd = AuthenticationServiceBase.toHexByte(plainTxtUserPassword);
        algorithm.update(bytePasswd);
        byte[] hashedVal = algorithm.digest();
        String hexString = "3b60" + StringUtil.toHexString(hashedVal, 0, hashedVal.length);
        return hexString;
    }

    private static byte[] toHexByte(String str) {
        byte[] data = new byte[str.length() * 2];
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int high_nibble = (ch & 0xF0) >>> 4;
            int low_nibble = ch & 0xF;
            data[i] = (byte)high_nibble;
            data[i + 1] = (byte)low_nibble;
        }
        return data;
    }

    String hashUsingDefaultAlgorithm(String user, String password, Dictionary props) throws StandardException {
        if (password == null) {
            return null;
        }
        PasswordHasher hasher = AuthenticationServiceBase.getDataDictionary().makePasswordHasher(props);
        if (hasher != null) {
            return hasher.hashAndEncode(user, password);
        }
        return this.hashPasswordSHA1Scheme(password);
    }

    private static DataDictionary getDataDictionary() {
        LanguageConnectionContext lcc = (LanguageConnectionContext)AuthenticationServiceBase.getContext("LanguageConnectionContext");
        return lcc.getDataDictionary();
    }

    protected String substitutePassword(String userName, String password, Properties info, boolean databaseUser) {
        MessageDigest messageDigest = null;
        byte[] SECMEC_USRSSBPWD_PWDSEQS = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] bytePasswd = null;
        byte[] userBytes = AuthenticationServiceBase.toHexByte(userName);
        SanityManager.ASSERT(info.getProperty("drdaSecTokenIn") != null && info.getProperty("drdaSecTokenOut") != null, "Unexpected: Requester or server seed not available");
        String sourceSeedstr = info.getProperty("drdaSecTokenIn");
        String targetSeedstr = info.getProperty("drdaSecTokenOut");
        byte[] sourceSeed_ = StringUtil.fromHexString(sourceSeedstr, 0, sourceSeedstr.length());
        byte[] targetSeed_ = StringUtil.fromHexString(targetSeedstr, 0, targetSeedstr.length());
        Object hexString = null;
        if (!databaseUser) {
            bytePasswd = AuthenticationServiceBase.toHexByte(password);
            messageDigest.update(bytePasswd);
            byte[] hashedVal = messageDigest.digest();
            hexString = "3b60" + StringUtil.toHexString(hashedVal, 0, hashedVal.length);
        } else {
            hexString = password;
        }
        messageDigest.update(userBytes);
        messageDigest.update(AuthenticationServiceBase.toHexByte((String)hexString));
        byte[] passwordToken = messageDigest.digest();
        messageDigest.update(passwordToken);
        messageDigest.update(targetSeed_);
        messageDigest.update(sourceSeed_);
        messageDigest.update(userBytes);
        messageDigest.update(SECMEC_USRSSBPWD_PWDSEQS);
        byte[] passwordSubstitute = messageDigest.digest();
        return StringUtil.toHexString(passwordSubstitute, 0, passwordSubstitute.length);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }

    private static String getServiceName(Object serviceModule) {
        return Monitor.getServiceName(serviceModule);
    }

    static Object getServiceModule(Object serviceModule, String factoryInterface) {
        return Monitor.getServiceModule(serviceModule, factoryInterface);
    }
}

