/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.db.ddl.delta.IDBTableDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBTableDelta;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;

public final class DBSchemaDelta
extends DBDelta
implements IDBSchemaDelta {
    private static final long serialVersionUID = 1L;
    private Map<String, IDBTableDelta> tableDeltas = new HashMap<String, IDBTableDelta>();

    public DBSchemaDelta(String name, IDBDelta.ChangeKind changeKind) {
        super(null, name, changeKind);
    }

    public DBSchemaDelta(IDBSchema schema, IDBSchema oldSchema) {
        this(schema.getName(), oldSchema == null ? IDBDelta.ChangeKind.ADD : IDBDelta.ChangeKind.CHANGE);
        IDBSchemaElement[] tables = schema.getTables();
        IDBSchemaElement[] oldTables = oldSchema == null ? InternalDBSchema.NO_TABLES : oldSchema.getTables();
        DBSchemaDelta.compare((InternalDBSchema)((InternalDBSchema)schema), (IDBSchemaElement[])tables, (IDBSchemaElement[])oldTables, (DBDelta.SchemaElementComparator)new DBDelta.SchemaElementComparator<IDBTable>(){

            @Override
            public void compare(IDBTable table, IDBTable oldTable) {
                DBTableDelta tableDelta = new DBTableDelta(DBSchemaDelta.this, table, oldTable);
                if (!tableDelta.isEmpty()) {
                    DBSchemaDelta.this.addTableDelta(tableDelta);
                }
            }
        });
    }

    protected DBSchemaDelta() {
    }

    @Override
    public IDBDelta.DeltaType getDeltaType() {
        return IDBDelta.DeltaType.SCHEMA;
    }

    @Override
    public int getTableDeltaCount() {
        return this.tableDeltas.size();
    }

    @Override
    public DBTableDelta getTableDelta(String name) {
        return (DBTableDelta)this.tableDeltas.get(name);
    }

    @Override
    public Map<String, IDBTableDelta> getTableDeltas() {
        return Collections.unmodifiableMap(this.tableDeltas);
    }

    @Override
    public IDBTableDelta[] getTableDeltasSortedByName() {
        Object[] result = this.tableDeltas.values().toArray(new IDBTableDelta[this.tableDeltas.size()]);
        Arrays.sort(result);
        return result;
    }

    public void addTableDelta(IDBTableDelta tableDelta) {
        this.tableDeltas.put(tableDelta.getName(), tableDelta);
        this.resetElements();
    }

    @Override
    public IDBSchema getSchemaElement(IDBSchema schema) {
        return schema;
    }

    @Override
    public void applyTo(IDBSchema schema) {
        Applier visitor = new Applier(schema);
        this.accept(visitor);
    }

    @Override
    public String toString() {
        return MessageFormat.format("DBSchemaDelta[name={0}, kind={1}, tableDeltas={2}]", new Object[]{this.getName(), this.getChangeKind(), this.tableDeltas.values()});
    }

    @Override
    protected void doAccept(IDBDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void collectElements(List<IDBDelta> elements) {
        elements.addAll(this.tableDeltas.values());
    }

    public static class Applier
    extends IDBDeltaVisitor.Default {
        private final IDBSchema schema;

        public Applier(IDBSchema schema) {
            this.schema = schema;
        }

        public final IDBSchema getSchema() {
            return this.schema;
        }

        @Override
        public void added(IDBTableDelta delta) {
            String name = delta.getName();
            this.schema.addTable(name);
        }

        @Override
        public void removed(IDBTableDelta delta) {
            IDBTable table = delta.getSchemaElement(this.schema);
            table.remove();
            this.stopRecursion();
        }

        @Override
        public void changed(IDBTableDelta delta) {
        }

        @Override
        public void added(IDBFieldDelta delta) {
            String name = delta.getName();
            DBType type = (DBType)((Object)delta.getPropertyValue("type"));
            int precision = (Integer)delta.getPropertyValue("precision");
            int scale = (Integer)delta.getPropertyValue("scale");
            boolean notNull = (Boolean)delta.getPropertyValue("notNull");
            IDBTable table = delta.getParent().getSchemaElement(this.schema);
            table.addField(name, type, precision, scale, notNull);
        }

        @Override
        public void removed(IDBFieldDelta delta) {
            IDBField field = delta.getSchemaElement(this.schema);
            field.remove();
        }

        @Override
        public void changed(IDBFieldDelta delta) {
        }

        @Override
        public void added(IDBIndexDelta delta) {
            String name = delta.getName();
            IDBIndex.Type type = (IDBIndex.Type)((Object)delta.getPropertyValue("type"));
            Boolean optional = (Boolean)delta.getPropertyValue("optional");
            IDBTable table = delta.getParent().getSchemaElement(this.schema);
            IDBIndex index = table.addIndexEmpty(name, type);
            DBUtil.setOptional(index, optional == Boolean.TRUE);
        }

        @Override
        public void removed(IDBIndexDelta delta) {
            IDBIndex index = delta.getSchemaElement(this.schema);
            index.remove();
        }

        @Override
        public void changed(IDBIndexDelta delta) {
        }

        @Override
        public void added(IDBIndexFieldDelta delta) {
            IDBIndexDelta parent = delta.getParent();
            IDBTable table = parent.getParent().getSchemaElement(this.schema);
            String name = delta.getName();
            IDBField field = table.getField(name);
            IDBIndex index = parent.getSchemaElement(this.schema);
            index.addIndexField(field);
        }

        @Override
        public void removed(IDBIndexFieldDelta delta) {
            IDBIndexField indexField = delta.getSchemaElement(this.schema);
            indexField.remove();
        }

        @Override
        public void changed(IDBIndexFieldDelta delta) {
        }
    }
}

