/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.PrintWriter;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.util.JBitSet;

public class DefaultOptTrace
implements OptTrace {
    private StringBuilder _buffer = new StringBuilder();

    @Override
    public void traceStartStatement(String statementText) {
        this.appendTraceString(statementText);
    }

    @Override
    public void traceStartQueryBlock(long timeOptimizationStarted, int optimizerID, OptimizableList optimizableList) {
        this.appendTraceString("Optimization started at time " + timeOptimizationStarted + " using optimizer " + optimizerID);
    }

    @Override
    public void traceEndQueryBlock() {
    }

    @Override
    public void traceTimeout(long currentTime, CostEstimate bestCost) {
        this.appendTraceString("Optimization time exceeded at time " + currentTime + "\n" + bestCost);
    }

    @Override
    public void traceVacuous() {
        this.appendTraceString("No tables to optimize.");
    }

    @Override
    public void traceCompleteJoinOrder() {
        this.appendTraceString("We have a complete join order.");
    }

    @Override
    public void traceSortCost(CostEstimate sortCost, CostEstimate currentCost) {
        this.appendTraceString("Cost of sorting is " + sortCost);
        this.appendTraceString("Total cost of non-sort-avoidance plan with sort cost added is " + currentCost);
    }

    @Override
    public void traceNoBestPlan() {
        this.appendTraceString("No best plan found.");
    }

    @Override
    public void traceModifyingAccessPaths(int optimizerID) {
        this.appendTraceString("Modifying access paths using optimizer " + optimizerID);
    }

    @Override
    public void traceShortCircuiting(boolean timeExceeded, Optimizable thisOpt, int joinPosition) {
        String basis;
        String string = basis = timeExceeded ? "time exceeded" : "cost";
        if (thisOpt.getBestAccessPath().getCostEstimate() == null) {
            basis = "no best plan found";
        }
        this.appendTraceString("Short circuiting based on " + basis + " at join position " + joinPosition);
    }

    @Override
    public void traceSkippingJoinOrder(int nextOptimizable, int joinPosition, int[] proposedJoinOrder, JBitSet assignedTableMap) {
        this.appendTraceString(this.reportJoinOrder("\n\nSkipping join order: ", true, nextOptimizable, joinPosition, proposedJoinOrder, assignedTableMap));
    }

    @Override
    public void traceIllegalUserJoinOrder() {
        this.appendTraceString("User specified join order is not legal.");
    }

    @Override
    public void traceUserJoinOrderOptimized() {
        this.appendTraceString("User-specified join order has now been optimized.");
    }

    @Override
    public void traceJoinOrderConsideration(int joinPosition, int[] proposedJoinOrder, JBitSet assignedTableMap) {
        this.appendTraceString(this.reportJoinOrder("\n\nConsidering join order: ", false, 0, joinPosition, proposedJoinOrder, assignedTableMap));
    }

    @Override
    public void traceCostWithoutSortAvoidance(CostEstimate currentCost) {
        this.appendTraceString("Total cost of non-sort-avoidance plan is " + currentCost);
    }

    @Override
    public void traceCostWithSortAvoidance(CostEstimate currentSortAvoidanceCost) {
        this.appendTraceString("Total cost of sort avoidance plan is " + currentSortAvoidanceCost);
    }

    @Override
    public void traceCurrentPlanAvoidsSort(CostEstimate bestCost, CostEstimate currentSortAvoidanceCost) {
        this.appendTraceString("Current plan is a sort avoidance plan.\n\tBest cost is : " + bestCost + "\n\tThis cost is : " + currentSortAvoidanceCost);
    }

    @Override
    public void traceCheapestPlanSoFar(int planType, CostEstimate currentCost) {
        this.appendTraceString("This is the cheapest plan so far.");
        this.appendTraceString("Plan is a " + (planType == 1 ? "normal" : "sort avoidance") + " plan.");
        this.appendTraceString("Cost of cheapest plan is " + currentCost);
    }

    @Override
    public void traceSortNeededForOrdering(int planType, RequiredRowOrdering requiredRowOrdering) {
        this.appendTraceString("Sort needed for ordering: " + (planType != 2) + "\n\tRow ordering: " + requiredRowOrdering);
    }

    @Override
    public void traceRememberingBestJoinOrder(int joinPosition, int[] bestJoinOrder, int planType, CostEstimate planCost, JBitSet assignedTableMap) {
        this.appendTraceString(this.reportJoinOrder("\n\nRemembering join order as best: ", false, 0, joinPosition, bestJoinOrder, assignedTableMap));
    }

    @Override
    public void traceSkippingBecauseTooMuchMemory(int maxMemoryPerTable) {
        this.appendTraceString("Skipping access path due to excess memory usage, maximum is " + maxMemoryPerTable);
    }

    @Override
    public void traceCostOfNScans(int tableNumber, double rowCount, CostEstimate cost) {
        this.appendTraceString("Cost of " + rowCount + " scans is: " + cost + " for table " + tableNumber);
    }

    @Override
    public void traceSkipUnmaterializableHashJoin() {
        this.appendTraceString("Skipping HASH JOIN because optimizable is not materializable");
    }

    @Override
    public void traceSkipHashJoinNoHashKeys() {
        this.appendTraceString("Skipping HASH JOIN because there are no hash key columns");
    }

    @Override
    public void traceHashKeyColumns(int[] hashKeyColumns) {
        String traceString = "# hash key columns = " + hashKeyColumns.length;
        for (int index = 0; index < hashKeyColumns.length; ++index) {
            traceString = "\n" + traceString + "hashKeyColumns[" + index + "] = " + hashKeyColumns[index];
        }
        this.appendTraceString(traceString);
    }

    @Override
    public void traceOptimizingJoinNode() {
        this.appendTraceString("Calling optimizeIt() for join node");
    }

    @Override
    public void traceConsideringJoinStrategy(JoinStrategy js, int tableNumber) {
        this.appendTraceString("\nConsidering join strategy " + js + " for table " + tableNumber);
    }

    @Override
    public void traceRememberingBestAccessPath(AccessPath accessPath, int tableNumber, int planType) {
        this.appendTraceString("Remembering access path " + accessPath + " as truly the best for table " + tableNumber + " for plan type " + (planType == 1 ? " normal " : "sort avoidance") + "\n");
    }

    @Override
    public void traceNoMoreConglomerates(int tableNumber) {
        this.appendTraceString("No more conglomerates to consider for table " + tableNumber);
    }

    @Override
    public void traceConsideringConglomerate(ConglomerateDescriptor cd, int tableNumber) {
        this.appendTraceString("\nConsidering conglomerate " + this.reportConglomerateDescriptor(cd) + " for table " + tableNumber);
    }

    @Override
    public void traceScanningHeapWithUniqueKey() {
        this.appendTraceString("Scanning heap, but we have a full match on a unique key.");
    }

    @Override
    public void traceAddingUnorderedOptimizable(int predicateCount) {
        this.appendTraceString("Adding unordered optimizable, # of predicates = " + predicateCount);
    }

    @Override
    public void traceChangingAccessPathForTable(int tableNumber) {
        this.appendTraceString("Changing access path for table " + tableNumber);
    }

    @Override
    public void traceNoStartStopPosition() {
        this.appendTraceString("Lock mode set to MODE_TABLE because no start or stop position");
    }

    @Override
    public void traceNonCoveringIndexCost(double cost, int tableNumber) {
        this.appendTraceString("Index does not cover query - cost including base row fetch is: " + cost + " for table " + tableNumber);
    }

    @Override
    public void traceConstantStartStopPositions() {
        this.appendTraceString("Lock mode set to MODE_RECORD because all start and stop positions are constant");
    }

    @Override
    public void traceEstimatingCostOfConglomerate(ConglomerateDescriptor cd, int tableNumber) {
        String cdString = this.reportConglomerateDescriptor(cd);
        this.appendTraceString("Estimating cost of conglomerate: " + this.reportCostForTable(cdString, tableNumber));
    }

    @Override
    public void traceLookingForSpecifiedIndex(String indexName, int tableNumber) {
        this.appendTraceString("Looking for user-specified index: " + indexName + " for table " + tableNumber);
    }

    @Override
    public void traceSingleMatchedRowCost(double cost, int tableNumber) {
        this.appendTraceString("Guaranteed to match a single row - cost is: " + cost + " for table " + tableNumber);
    }

    @Override
    public void traceCostIncludingExtra1stColumnSelectivity(CostEstimate cost, int tableNumber) {
        this.appendTraceString("Cost including extra first column selectivity is : " + cost + " for table " + tableNumber);
    }

    @Override
    public void traceNextAccessPath(String baseTable, int predicateCount) {
        this.appendTraceString("Calling nextAccessPath() for base table " + baseTable + " with " + predicateCount + " predicates.");
    }

    @Override
    public void traceCostIncludingExtraStartStop(CostEstimate cost, int tableNumber) {
        this.appendTraceString(this.reportCostIncluding("start/stop", cost, tableNumber));
    }

    @Override
    public void traceCostIncludingExtraQualifierSelectivity(CostEstimate cost, int tableNumber) {
        this.appendTraceString(this.reportCostIncluding("qualifier", cost, tableNumber));
    }

    @Override
    public void traceCostIncludingExtraNonQualifierSelectivity(CostEstimate cost, int tableNumber) {
        this.appendTraceString(this.reportCostIncluding("non-qualifier", cost, tableNumber));
    }

    @Override
    public void traceCostOfNoncoveringIndex(CostEstimate cost, int tableNumber) {
        this.appendTraceString("Index does not cover query: cost including row fetch is: " + this.reportCostForTable(cost, tableNumber));
    }

    @Override
    public void traceRememberingJoinStrategy(JoinStrategy joinStrategy, int tableNumber) {
        this.appendTraceString("\nRemembering join strategy " + joinStrategy + " as best for table " + tableNumber);
    }

    @Override
    public void traceRememberingBestAccessPathSubstring(AccessPath ap, int tableNumber) {
        this.appendTraceString("in best access path");
    }

    @Override
    public void traceRememberingBestSortAvoidanceAccessPathSubstring(AccessPath ap, int tableNumber) {
        this.appendTraceString("in best sort avoidance access path");
    }

    @Override
    public void traceRememberingBestUnknownAccessPathSubstring(AccessPath ap, int tableNumber) {
        this.appendTraceString("in best unknown access path");
    }

    @Override
    public void traceCostOfConglomerateScan(int tableNumber, ConglomerateDescriptor cd, CostEstimate costEstimate, int numExtraFirstColumnPreds, double extraFirstColumnSelectivity, int numExtraStartStopPreds, double extraStartStopSelectivity, int startStopPredCount, double statStartStopSelectivity, int numExtraQualifiers, double extraQualifierSelectivity, int numExtraNonQualifiers, double extraNonQualifierSelectivity) {
        this.appendTraceString("Cost of conglomerate " + this.reportConglomerateDescriptor(cd) + " scan for table number " + tableNumber + " is : ");
        this.appendTraceString(costEstimate.toString());
        this.appendTraceString("\tNumber of extra first column predicates is : " + numExtraFirstColumnPreds + ", extra first column selectivity is : " + extraFirstColumnSelectivity);
        this.appendTraceString("\tNumber of extra start/stop predicates is : " + numExtraStartStopPreds + ", extra start/stop selectivity is : " + extraStartStopSelectivity);
        this.appendTraceString("\tNumber of start/stop statistics predicates is : " + startStopPredCount + ", statistics start/stop selectivity is : " + statStartStopSelectivity);
        this.appendTraceString("\tNumber of extra qualifiers is : " + numExtraQualifiers + ", extra qualifier selectivity is : " + extraQualifierSelectivity);
        this.appendTraceString("\tNumber of extra non-qualifiers is : " + numExtraNonQualifiers + ", extra non-qualifier selectivity is : " + extraNonQualifierSelectivity);
    }

    @Override
    public void traceCostIncludingCompositeSelectivityFromStats(CostEstimate cost, int tableNumber) {
        this.appendTraceString(this.reportCostIncluding("selectivity from statistics", cost, tableNumber));
    }

    @Override
    public void traceCompositeSelectivityFromStatistics(double statCompositeSelectivity) {
        this.appendTraceString("Selectivity from statistics found. It is " + statCompositeSelectivity);
    }

    @Override
    public void traceCostIncludingStatsForIndex(CostEstimate cost, int tableNumber) {
        this.appendTraceString(this.reportCostIncluding("statistics for index being considered", cost, tableNumber));
    }

    @Override
    public void printToWriter(PrintWriter out) {
        out.println(this._buffer.toString());
    }

    private String reportJoinOrder(String prefix, boolean addJoinOrderNumber, int joinOrderNumber, int joinPosition, int[] joinOrder, JBitSet assignedTableMap) {
        StringBuilder joinOrderString = new StringBuilder();
        joinOrderString.append(prefix);
        for (int i = 0; i <= joinPosition; ++i) {
            joinOrderString.append(" ").append(joinOrder[i]);
        }
        if (addJoinOrderNumber) {
            joinOrderString.append(" ").append(joinOrderNumber);
        }
        joinOrderString.append(" with assignedTableMap = ").append(assignedTableMap).append("\n\n");
        return joinOrderString.toString();
    }

    private String reportConglomerateDescriptor(ConglomerateDescriptor cd) {
        return cd.toString();
    }

    private String reportCostForTable(Object cost, int tableNumber) {
        return cost + " for table " + tableNumber;
    }

    private String reportCostIncluding(String selectivityType, CostEstimate cost, int tableNumber) {
        return "Cost including extra " + selectivityType + " start/stop selectivity is : " + this.reportCostForTable(cost, tableNumber);
    }

    private void appendTraceString(String traceString) {
        this._buffer.append(traceString);
        this._buffer.append("\n");
    }
}

