/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

class LockTableConstantAction
implements ConstantAction {
    private final String fullTableName;
    private final long conglomerateNumber;
    private final boolean exclusiveMode;

    LockTableConstantAction(String fullTableName, long conglomerateNumber, boolean exclusiveMode) {
        this.fullTableName = fullTableName;
        this.conglomerateNumber = conglomerateNumber;
        this.exclusiveMode = exclusiveMode;
    }

    public String toString() {
        return "LOCK TABLE " + this.fullTableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController tc = activation.getTransactionController();
        try {
            ConglomerateController cc = tc.openConglomerate(this.conglomerateNumber, false, this.exclusiveMode ? 68 : 64, 7, 5);
            cc.close();
        }
        catch (StandardException se) {
            String msgId = se.getMessageId();
            if (se.isLockTimeoutOrDeadlock()) {
                String mode = this.exclusiveMode ? "EXCLUSIVE" : "SHARE";
                se = StandardException.newException("X0X02.S", se, this.fullTableName, mode);
            }
            throw se;
        }
    }
}

