/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.ExplicitSourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.ImplicitEcoreSourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.ImplicitUMLSourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.NameKind;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SourceTraceHelper;

public class ComposedSourceTraceHelper
implements SourceTraceHelper {
    private final List<SourceTraceHelper> delegates = List.of(new ExplicitSourceTraceHelper(), new ImplicitUMLSourceTraceHelper(), new ImplicitEcoreSourceTraceHelper());

    @Override
    public EObject getSourceElement(EObject propertiesElement) {
        return this.iterate(propertiesElement, null, SourceTraceHelper::getSourceElement);
    }

    @Override
    public List<? extends EObject> getNestedPackages(EObject sourcePackage) {
        return this.iterate(sourcePackage, List.of(), SourceTraceHelper::getNestedPackages);
    }

    @Override
    public List<? extends EObject> getClasses(EObject sourcePackage) {
        return this.iterate(sourcePackage, List.of(), SourceTraceHelper::getClasses);
    }

    @Override
    public List<? extends EObject> getProperties(EObject sourceClass) {
        return this.iterate(sourceClass, List.of(), SourceTraceHelper::getProperties);
    }

    @Override
    public boolean isPropertyRedefinition(EObject sourceProperty) {
        return this.iterate(sourceProperty, false, SourceTraceHelper::isPropertyRedefinition);
    }

    @Override
    public List<? extends EObject> getSuperclasses(EObject sourceClass) {
        return this.iterate(sourceClass, List.of(), SourceTraceHelper::getSuperclasses);
    }

    @Override
    public ConstraintDescriptor createInstanceOfConstraint(EObject sourceClass) {
        return this.iterate(sourceClass, null, SourceTraceHelper::createInstanceOfConstraint);
    }

    @Override
    public boolean isInstanceOfConstraint(ConstraintDescriptor constraint) {
        return this.iterate(constraint, false, SourceTraceHelper::isInstanceOfConstraint);
    }

    @Override
    public EObject resolveInstanceOfConstraintClass(ConstraintDescriptor constraint) {
        return this.iterate(constraint, null, SourceTraceHelper::resolveInstanceOfConstraintClass);
    }

    @Override
    public String getClassName(ConstraintDescriptor instanceOfConstraint) {
        return this.iterate(instanceOfConstraint, null, SourceTraceHelper::getClassName);
    }

    @Override
    public ValueProperty getClassNameProperty(ConstraintDescriptor instanceOfConstraint) {
        return this.iterate(instanceOfConstraint, null, SourceTraceHelper::getClassNameProperty);
    }

    @Override
    public Collection<? extends EObject> getValidConstraintSourceClasses(ConstraintDescriptor instanceOfConstraint, EObject sourceClass) {
        return this.iterate(instanceOfConstraint, List.of(sourceClass), (h, c) -> h.getValidConstraintSourceClasses((ConstraintDescriptor)c, sourceClass));
    }

    @Override
    public IGenerator createGenerator(EObject sourceClass) {
        return this.iterate(sourceClass, null, SourceTraceHelper::createGenerator);
    }

    @Override
    public String getName(EObject sourceElement, NameKind kind) {
        return this.iterate(sourceElement, null, (h, e) -> h.getName((EObject)e, kind));
    }

    @Override
    public int getMultiplicity(EObject sourceProperty) {
        return this.iterate(sourceProperty, DEFAULT_MULTIPLICITY, SourceTraceHelper::getMultiplicity);
    }

    @Override
    public boolean isViewOf(View view, DataContextElement element) {
        return this.iterate(view, false, (helper, v) -> helper.isViewOf((View)v, element));
    }

    @Override
    public boolean isSectionFor(Section section, DataContextElement element) {
        return this.iterate(section, false, (helper, s) -> helper.isSectionFor((Section)s, element));
    }

    private <T, R> R iterate(T input, R defaultResult, BiFunction<SourceTraceHelper, ? super T, ? extends R> function) {
        R result = null;
        Iterator<SourceTraceHelper> iter = this.delegates.iterator();
        while ((result == null || Objects.equals(result, defaultResult)) && iter.hasNext()) {
            result = function.apply(iter.next(), (SourceTraceHelper)input);
        }
        return result != null ? result : (R)defaultResult;
    }
}

