/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class DestroyElementPapyrusCommand
extends DestroyElementCommand {
    private List<Object> affectedFiles;

    public DestroyElementPapyrusCommand(DestroyElementRequest request) {
        super(request);
    }

    public List<Object> getAffectedFiles() {
        if (this.affectedFiles == null) {
            this.affectedFiles = new ArrayList<Object>(super.getAffectedFiles());
            this.affectedFiles.addAll(this.fileOfIncomingReferences(((DestroyElementRequest)this.getRequest()).getElementToDestroy()));
        }
        return this.affectedFiles;
    }

    protected List fileOfIncomingReferences(EObject destructee) {
        if (destructee != null) {
            Collection usages = EMFHelper.getUsages((EObject)destructee);
            ArrayList<IFile> result = new ArrayList<IFile>();
            HashSet<Resource> resources = new HashSet<Resource>();
            for (EStructuralFeature.Setting setting : usages) {
                Resource resource;
                EReference eRef;
                if (!(setting.getEStructuralFeature() instanceof EReference) || !(eRef = (EReference)setting.getEStructuralFeature()).isChangeable() || eRef.isDerived() || eRef.isContainment() || eRef.isContainer() || (resource = setting.getEObject().eResource()) == null) continue;
                resources.add(resource);
            }
            for (Resource resource : resources) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
                if (file == null) continue;
                result.add(file);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected void tearDownIncomingReferences(EObject destructee) {
        Collection usages = EMFHelper.getUsages((EObject)destructee);
        for (EStructuralFeature.Setting setting : usages) {
            EReference eRef;
            if (!(setting.getEStructuralFeature() instanceof EReference) || !(eRef = (EReference)setting.getEStructuralFeature()).isChangeable() || eRef.isDerived() || eRef.isContainment() || eRef.isContainer()) continue;
            EcoreUtil.remove((EObject)setting.getEObject(), (EStructuralFeature)eRef, (Object)destructee);
        }
    }
}

