/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.NamedElement;

public class DuplicateNamedElementCommand
extends DuplicateEObjectsCommand {
    protected Diagram diagram;

    public DuplicateNamedElementCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated, Map allDuplicatedObjectsMap, Diagram currentDiagram) {
        super(editingDomain, label, eObjectsToBeDuplicated, allDuplicatedObjectsMap);
        this.diagram = currentDiagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        super.doExecuteWithResult(progressMonitor, info);
        List objectsToBeDuplicated = this.getObjectsToBeDuplicated();
        for (Object object : objectsToBeDuplicated) {
            if (!(object instanceof NamedElement)) continue;
            Object duplicatedObject = this.getAllDuplicatedObjectsMap().get(object);
            NamedElement namedDuplicatedObject = (NamedElement)duplicatedObject;
            String incrementedName = NamedElementUtil.getDefaultCopyNameWithIncrement((NamedElement)namedDuplicatedObject, (Collection)this.diagram.getElement().eContents());
            namedDuplicatedObject.setName(incrementedName);
        }
        return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
    }
}

