/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.rcptt.core.ecl.model.Declaration;
import org.eclipse.rcptt.core.ecl.model.SrcLoc;
import org.eclipse.rcptt.ecl.doc.EclDocWriter;

public class VarDecl
extends Declaration {
    public boolean isInput;
    public boolean hasDefaultValue;
    public String simpleValue;
    public boolean isGlobal = false;

    public VarDecl(String name, SrcLoc location) {
        super(name, location);
    }

    @Override
    public String doc() {
        StringWriter sw = new StringWriter();
        EclDocWriter dw = new EclDocWriter((Writer)sw);
        try {
            String path;
            dw.text(String.format("%s variable <b>%s</b>", this.isGlobal ? "Global" : "Local", this.name));
            dw.dl();
            if (this.hasDefaultValue && this.simpleValue != null) {
                dw.dt("Default value:");
                dw.dd(VarDecl.defaultValueForDoc(this.simpleValue));
            }
            if (this.isGlobal && (path = VarDecl.getResourcePath(this.container.getResource())) != null) {
                dw.dt("Defined in:");
                dw.dd(path);
            }
            dw.close();
            if (this.isInput) {
                dw.text("<p>This parameter is marked as <i>input</i> parameter and may be omited. In this case, actual argument value will be taken from the pipe. Typically, that will be a result of the previous command execution.</p>");
            }
            dw.finish();
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }
}

