/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.dnd;

import aQute.bnd.exceptions.Exceptions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.bnd.ui.dnd.BndDropTargetListener;
import org.eclipse.pde.bnd.ui.dnd.GradleDropTargetListener;
import org.eclipse.pde.bnd.ui.dnd.MavenDropTargetListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.part.EditorPart;

public class GAVIPageListener
implements IPartListener {
    private final Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};

    public void partOpened(IWorkbenchPart part) {
        IDragAndDropService dndService = (IDragAndDropService)part.getSite().getService(IDragAndDropService.class);
        if (dndService == null) {
            return;
        }
        Control control = (Control)part.getAdapter(Control.class);
        if (control == null || !(control instanceof StyledText)) {
            return;
        }
        IPath file = null;
        if (part instanceof EditorPart) {
            EditorPart editorPart = (EditorPart)part;
            IEditorInput editorInput = editorPart.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)editorInput;
                file = input.getFile().getFullPath();
            } else if (editorInput instanceof IStorageEditorInput) {
                IStorageEditorInput input = (IStorageEditorInput)editorInput;
                try {
                    file = input.getStorage().getFullPath();
                }
                catch (CoreException e) {
                    throw Exceptions.duck((Throwable)e);
                }
            }
        }
        if (file != null) {
            String fileName = file.lastSegment();
            String fileExtension = file.getFileExtension();
            if ("pom.xml".equals(fileName)) {
                dndService.addMergedDropTarget(control, 1, this.transfers, (DropTargetListener)new MavenDropTargetListener((StyledText)control));
            } else if ("gradle".equalsIgnoreCase(fileExtension)) {
                dndService.addMergedDropTarget(control, 1, this.transfers, (DropTargetListener)new GradleDropTargetListener((StyledText)control));
            } else if ("bnd".equalsIgnoreCase(fileExtension) || "bndrun".equalsIgnoreCase(fileExtension)) {
                dndService.addMergedDropTarget(control, 1, this.transfers, (DropTargetListener)new BndDropTargetListener((StyledText)control));
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        IDragAndDropService dndService = (IDragAndDropService)part.getSite().getService(IDragAndDropService.class);
        Control control = (Control)part.getAdapter(Control.class);
        if (control != null && dndService != null) {
            dndService.removeMergedDropTarget(control);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }
}

