/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SectionWithComposite {
    private final String name;
    private final int style;
    private int numColumns = 1;
    private boolean grabVertical = true;
    private Section section;
    private Composite composite;

    public SectionWithComposite(String name, int style) {
        this.name = name;
        this.style = style;
    }

    public Section getSection() {
        return this.section;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public SectionWithComposite numColumns(int numColumns) {
        this.numColumns = numColumns;
        return this;
    }

    public SectionWithComposite grabVertical(boolean grabVertical) {
        this.grabVertical = grabVertical;
        return this;
    }

    public Section create(Composite parent, FormToolkit toolkit) {
        boolean twistie = (this.style & 2) != 0;
        boolean expanded = !twistie || (this.style & 0x40) != 0;
        this.section = toolkit.createSection(parent, this.style | 0x4000);
        this.section.setText(this.name);
        GridDataFactory.fillDefaults().grab(true, this.grabVertical && expanded).applyTo((Control)this.section);
        this.composite = toolkit.createComposite((Composite)this.section);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).numColumns(this.numColumns).applyTo(this.composite);
        this.section.setClient((Control)this.composite);
        if (twistie) {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    GridDataFactory.fillDefaults().grab(true, SectionWithComposite.this.grabVertical && SectionWithComposite.this.section.isExpanded()).applyTo((Control)SectionWithComposite.this.section);
                    SectionWithComposite.this.section.getParent().layout();
                }
            });
        }
        return this.section;
    }
}

