/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.refactoring.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.utils.EclipseObjects;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public abstract class RefactoringAction
extends Action {
    protected CEditor fEditor;
    private IWorkbenchSite fSite;
    private ICElement fElement;
    private boolean saveRequired;

    public RefactoringAction(String label) {
        super(label);
    }

    @Deprecated
    public void setSaveRequired(boolean saveRequired) {
        this.saveRequired = saveRequired;
    }

    public void setEditor(IEditorPart editor) {
        this.fEditor = null;
        this.fSite = null;
        if (editor instanceof CEditor) {
            this.fEditor = (CEditor)editor;
        }
        this.setEnabled(this.fEditor != null);
    }

    public void setSite(IWorkbenchSite site) {
        this.fEditor = null;
        this.fSite = site;
    }

    public final void run() {
        if (this.saveRequired) {
            EclipseObjects.getActivePage().saveAllEditors(true);
            if (EclipseObjects.getActivePage().getDirtyEditors().length != 0) {
                return;
            }
        }
        if (this.fEditor != null) {
            IWorkingCopy wc;
            ISelection s;
            ISelectionProvider provider = this.fEditor.getSelectionProvider();
            if (provider != null && (s = provider.getSelection()) instanceof ITextSelection && (wc = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput())) != null) {
                this.run((IShellProvider)this.fEditor.getSite(), wc, (ITextSelection)s);
            }
        } else if (this.fSite != null && this.fElement != null) {
            this.run((IShellProvider)this.fSite, this.fElement);
        }
    }

    public void updateSelection(ICElement elem) {
        this.fElement = elem;
        this.setEnabled(elem != null);
    }

    public abstract void run(IShellProvider var1, IWorkingCopy var2, ITextSelection var3);

    public abstract void run(IShellProvider var1, ICElement var2);
}

