/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.actions.Messages;
import org.eclipse.dltk.internal.debug.ui.actions.ScriptEvaluationAction;
import org.eclipse.swt.widgets.Display;

public abstract class ScriptDisplayAction
extends ScriptEvaluationAction {
    public static String trimDisplayResult(String result) {
        int max = DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
        if (max > 0 && ((String)result).length() > max) {
            result = ((String)result).substring(0, max) + "...";
        }
        return result;
    }

    @Override
    protected void displayResult(IScriptEvaluationResult result) {
        if (result.hasErrors()) {
            Display display = DLTKDebugUIPlugin.getStandardDisplay();
            display.asyncExec(() -> {
                if (display.isDisposed()) {
                    return;
                }
                this.reportErrors(result);
                this.evaluationCleanup();
            });
            return;
        }
        String snippet = result.getSnippet();
        IScriptValue resultValue = result.getValue();
        String typeName = resultValue.getType().getName();
        IDebugModelPresentation presentation = ScriptDisplayAction.getDebugModelPresentation(result.getThread().getModelIdentifier());
        presentation.computeDetail((IValue)resultValue, (value, result1) -> this.displayStringResult(snippet, MessageFormat.format(Messages.ScriptDisplayAction_displayResult, typeName, ScriptDisplayAction.trimDisplayResult(result1))));
        presentation.dispose();
    }

    protected abstract void displayStringResult(String var1, String var2);
}

