/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;
import org.eclipse.equinox.weaving.internal.caching.CacheItemKey;
import org.eclipse.equinox.weaving.internal.caching.ClassnameLockManager;
import org.eclipse.equinox.weaving.internal.caching.Log;

public class CacheWriter {
    private static final long JOIN_TIMEOUT = 5000L;
    private final Map<CacheItemKey, byte[]> itemsInQueue;
    private final ClassnameLockManager lockManager;
    private final Thread writerThread;

    public CacheWriter(BlockingQueue<CacheItem> cacheQueue, Map<CacheItemKey, byte[]> itemsInQueue, ClassnameLockManager lockManager) {
        this.itemsInQueue = itemsInQueue;
        this.lockManager = lockManager;
        this.writerThread = new Thread(() -> {
            try {
                while (true) {
                    CacheItem item = (CacheItem)cacheQueue.take();
                    this.store(item);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.writerThread.setPriority(1);
    }

    public void start() {
        this.writerThread.start();
    }

    public void stop() {
        this.writerThread.interrupt();
        try {
            this.writerThread.join(5000L);
        }
        catch (InterruptedException e) {
            Log.error("Interrupted while joining the writerThread", e);
            Thread.currentThread().interrupt();
        }
    }

    protected void store(CacheItem item) {
        Map<String, byte[]> generatedClasses = item.getGeneratedClasses();
        if (generatedClasses != null) {
            for (Map.Entry<String, byte[]> entry : generatedClasses.entrySet()) {
                String className = entry.getKey();
                byte[] classBytes = entry.getValue();
                this.lockManager.executeWrite(className, () -> this.storeSingleClass(className, classBytes, item.getDirectory()));
            }
        }
        this.lockManager.executeWrite(item.getName(), () -> this.storeSingleClass(item.getName(), item.getCachedBytes(), item.getDirectory()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeSingleClass(String className, byte[] classBytes, String cacheDirectory) {
        boolean success;
        File outputFile;
        block19: {
            File directory = new File(cacheDirectory);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            outputFile = new File(directory, className);
            success = true;
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try {
                    FileOutputStream fosCache = new FileOutputStream(outputFile);
                    try {
                        try (DataOutputStream outCache = new DataOutputStream(new BufferedOutputStream(fosCache));){
                            outCache.write(classBytes);
                            outCache.flush();
                            fosCache.getFD().sync();
                        }
                        if (fosCache == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fosCache == null) throw throwable;
                        fosCache.close();
                        throw throwable;
                    }
                    fosCache.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                Log.error("Failed to store class " + className + " in cache", e);
                success = false;
            }
        }
        if ((!success || Thread.currentThread().isInterrupted()) && outputFile.exists() && outputFile.length() != (long)classBytes.length) {
            Log.debug("File " + outputFile.getAbsolutePath() + " was not completely written to disk. Removing it.");
            try {
                Files.delete(outputFile.toPath());
            }
            catch (IOException e) {
                Log.error("File " + outputFile.getAbsolutePath() + " is corrupted but could not be deleted.", e);
                outputFile.deleteOnExit();
            }
        }
        this.itemsInQueue.remove(new CacheItemKey(cacheDirectory, className));
    }
}

