/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.IColorConstant;

public class AddChessMoveFeature
extends AbstractAddFeature {
    public AddChessMoveFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context instanceof IAddConnectionContext && context.getProperty((Object)"move") == Boolean.TRUE;
    }

    public PictogramElement add(IAddContext context) {
        IAddConnectionContext addConContext = (IAddConnectionContext)context;
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setLineWidth(Integer.valueOf(2));
        polyline.setForeground(this.manageColor(IColorConstant.ORANGE));
        ConnectionDecorator cd = peCreateService.createConnectionDecorator((Connection)connection, false, 0.0, true);
        Ellipse circle = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)cd);
        circle.setLineWidth(Integer.valueOf(2));
        gaService.setLocationAndSize((GraphicsAlgorithm)circle, 0, 0, 6, 6);
        circle.setForeground(this.manageColor(IColorConstant.ORANGE));
        cd = peCreateService.createConnectionDecorator((Connection)connection, false, 1.0, true);
        int[] nArray = new int[10];
        nArray[0] = -5;
        nArray[1] = -5;
        nArray[2] = 5;
        nArray[3] = 5;
        nArray[6] = -5;
        nArray[7] = 5;
        nArray[8] = 5;
        nArray[9] = -5;
        Polyline crossPolyline = Graphiti.getGaCreateService().createPolyline((GraphicsAlgorithmContainer)cd, nArray);
        crossPolyline.setLineWidth(Integer.valueOf(2));
        crossPolyline.setForeground(this.manageColor(IColorConstant.ORANGE));
        peCreateService.createChopboxAnchor((AnchorContainer)connection);
        peCreateService.createChopboxAnchor((AnchorContainer)cd);
        return connection;
    }
}

