/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtCompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtNamespace;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtProject;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtBaseElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtCompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtElementMemberColllector;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtModelException;

public class QvtNamespace
extends QvtBaseElement
implements IQvtNamespace {
    private QvtNamespace fParentNamespace;
    private IContainer fContainer;
    private List<IQvtCompilationUnit> compilationUnits;
    private List<IQvtNamespace> ownedNamespaces;

    protected QvtNamespace(QvtNamespace parent, String name) {
        super(parent, name);
        this.fParentNamespace = parent;
    }

    protected QvtNamespace(IPath parentPath, String name) {
        super(parentPath, name);
        this.fParentNamespace = null;
    }

    @Override
    public IQvtProject getQvtProject() {
        return this.fParentNamespace.getQvtProject();
    }

    @Override
    public int getElementType() {
        return 2;
    }

    @Override
    public List<IQvtCompilationUnit> getCompilationUnits() throws QvtModelException {
        if (this.compilationUnits == null) {
            IContainer container = (IContainer)this.getUnderlyingResource();
            List<String> moduleFileNames = null;
            try {
                moduleFileNames = QvtElementMemberColllector.getMemberModules(container);
                ArrayList<IQvtCompilationUnit> units = new ArrayList<IQvtCompilationUnit>(moduleFileNames.size());
                for (String moduleFileName : moduleFileNames) {
                    units.add(new QvtCompilationUnit(this, moduleFileName));
                }
                this.compilationUnits = units;
            }
            catch (CoreException e) {
                this.propagateAsQvtModelException("Can't retrieve compilation units", e);
            }
        }
        return this.compilationUnits;
    }

    @Override
    public IQvtCompilationUnit findCompilationUnit(String compilationUnitName) throws QvtModelException {
        if (!this.getUnderlyingResource().exists()) {
            return null;
        }
        for (IQvtCompilationUnit cu : this.getCompilationUnits()) {
            if (!cu.getName().equals(compilationUnitName)) continue;
            return cu;
        }
        return null;
    }

    @Override
    public IQvtNamespace findOwnedNamespace(String namespaceSimpleName) throws QvtModelException {
        for (IQvtNamespace namespace : this.getOwnedNamespaces()) {
            if (!namespace.getName().equals(namespaceSimpleName)) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public IResource getUnderlyingResource() throws QvtModelException {
        if (this.fContainer == null) {
            IPath path = this.getFullPath();
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.fContainer = path.segmentCount() > 1 ? wsRoot.getFolder(path) : wsRoot.getProject(path.segment(0));
        }
        return this.fContainer;
    }

    @Override
    public List<IQvtNamespace> getOwnedNamespaces() throws QvtModelException {
        if (this.ownedNamespaces == null) {
            try {
                IContainer container = (IContainer)this.getUnderlyingResource();
                List<String> folderNames = QvtElementMemberColllector.getMemberNamespaces(container);
                ArrayList<IQvtNamespace> namespaces = new ArrayList<IQvtNamespace>(folderNames.size());
                for (String folderName : folderNames) {
                    namespaces.add(new QvtNamespace(this, folderName));
                }
                this.ownedNamespaces = namespaces;
            }
            catch (CoreException e) {
                this.propagateAsQvtModelException("Can't retrieve compilation units", e);
            }
        }
        return this.ownedNamespaces;
    }

    @Override
    public String getQualifiedName() {
        if (this.fParentNamespace == null) {
            return this.getName();
        }
        return String.valueOf(this.fParentNamespace.getQualifiedName()) + "." + this.getName();
    }

    @Override
    public IQvtNamespace getParentNamespace() {
        return this.fParentNamespace;
    }

    @Override
    public boolean isDefaultNamespace() {
        return "".equals(this.getName());
    }
}

