/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.files.ui.compare.SystemCompareInput;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemCompareFilesAction
extends SystemBaseAction {
    private List _selected;

    public SystemCompareFilesAction(Shell parent) {
        super(FileResources.ACTION_COMPAREWITH_EACH_LABEL, parent);
        this.setToolTipText(FileResources.ACTION_COMPAREWITH_EACH_TOOLTIP);
        this._selected = new ArrayList();
        this.allowOnMultipleSelection(true);
    }

    public void run() {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)new Boolean(false));
        SystemCompareInput fInput = new SystemCompareInput(cc);
        int i = 0;
        while (i < this._selected.size()) {
            IRemoteFile file = (IRemoteFile)this._selected.get(i);
            try {
                file = file.getParentRemoteFileSubSystem().getRemoteFileObject(file.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                file.markStale(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SystemEditableRemoteFile ef = new SystemEditableRemoteFile(file);
            fInput.addRemoteEditable(ef);
            ++i;
        }
        CompareUI.openCompareEditor((CompareEditorInput)fInput);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this._selected.clear();
        boolean enable = false;
        Iterator e = selection.iterator();
        while (e.hasNext()) {
            Object selected = e.next();
            if (selected != null && selected instanceof IRemoteFile) {
                IRemoteFile file = (IRemoteFile)selected;
                if (file.isFile()) {
                    this._selected.add(file);
                    if (this._selected.size() == 2) {
                        enable = true;
                        continue;
                    }
                    enable = false;
                    continue;
                }
                return false;
            }
            return false;
        }
        return enable;
    }
}

