/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.GenericPropertyGetValue;
import org.eclipse.wb.core.model.broadcast.GenericPropertyGetValueEx;
import org.eclipse.wb.core.model.broadcast.GenericPropertySetValue;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyComposite;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class GenericPropertyImpl
extends GenericProperty {
    private final GenericPropertyImpl m_this = this;
    private final ExpressionAccessor[] m_accessors;
    private final Object m_defaultValue;
    private final ExpressionConverter m_converter;
    private GenericPropertyDescription m_description;
    private Class<?> m_type;

    public GenericPropertyImpl(JavaInfo javaInfo, String title, ExpressionAccessor[] accessors, Object defaultValue, ExpressionConverter converter, PropertyEditor propertyEditor) {
        super(javaInfo, title, propertyEditor);
        this.m_accessors = accessors;
        this.m_defaultValue = defaultValue;
        this.m_converter = converter;
    }

    public GenericPropertyImpl(GenericPropertyImpl property) {
        this(property, property.getTitle());
    }

    public GenericPropertyImpl(GenericPropertyImpl property, String title) {
        this(property.m_javaInfo, title, property.m_accessors, property.m_defaultValue, property.m_converter, property.getEditor());
        this.setCategory(property.getCategory());
        this.setDescription(property.getDescription());
        this.setType(property.getType());
    }

    public boolean isModified() {
        return this.getExpressionInfo() != null;
    }

    public Class<?> getType() {
        return this.m_type;
    }

    public void setType(Class<?> type) {
        this.m_type = type;
    }

    public GenericPropertyDescription getDescription() {
        return this.m_description;
    }

    public void setDescription(GenericPropertyDescription description) {
        this.m_description = description;
        if (this.m_description != null) {
            this.m_type = this.m_description.getType();
        }
    }

    @Override
    public Object getValue() throws Exception {
        Object[] valueArray = new Object[]{UNKNOWN_VALUE};
        ((GenericPropertyGetValue)this.m_javaInfo.getBroadcast(GenericPropertyGetValue.class)).invoke(this, valueArray);
        if (valueArray[0] != UNKNOWN_VALUE) {
            return valueArray[0];
        }
        Expression expression = this.getExpression();
        if (expression != null) {
            Object value = JavaInfoEvaluationHelper.getValue(expression);
            Object[] valueArray2 = new Object[]{value};
            ((GenericPropertyGetValueEx)this.m_javaInfo.getBroadcast(GenericPropertyGetValueEx.class)).invoke(this, expression, valueArray2);
            value = valueArray2[0];
            return value;
        }
        return this.getDefaultValue();
    }

    @Override
    public Object getDefaultValue() {
        if (this.m_defaultValue != UNKNOWN_VALUE) {
            return this.m_defaultValue;
        }
        Object accessor_defaultValue = this.m_accessors[0].getDefaultValue(this.m_javaInfo);
        if (accessor_defaultValue != UNKNOWN_VALUE) {
            return accessor_defaultValue;
        }
        return UNKNOWN_VALUE;
    }

    public void setValue(final Object value) throws Exception {
        if (this.process_NLSSupport_specialFunctionality(value)) {
            return;
        }
        ExecutionUtils.run((ObjectInfo)this.m_javaInfo, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GenericPropertyImpl.this.setValueEx(value);
            }
        });
    }

    private boolean process_NLSSupport_specialFunctionality(final Object value) throws Exception {
        Expression expression;
        if (value == UNKNOWN_VALUE) {
            return false;
        }
        if (!NlsSupport.isStringProperty((Property)this)) {
            return false;
        }
        final NlsSupport support = NlsSupport.get(this.m_javaInfo);
        if (value instanceof String) {
            String key;
            AbstractSource source;
            String stringValue = (String)value;
            String keyPrefix = this.m_javaInfo.getDescription().getToolkit().getPreferences().getString("nls.prefixOfPropertyValueToSpecifyThatItIsKey");
            if (!StringUtils.isEmpty((CharSequence)keyPrefix) && stringValue.startsWith(keyPrefix) && (source = support.getKeySource(key = stringValue.substring(keyPrefix.length()))) != null) {
                ExecutionUtils.run((ObjectInfo)this.m_javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        source.useKey(GenericPropertyImpl.this.m_this, key);
                    }
                });
                return true;
            }
        }
        if ((expression = this.getExpression()) != null && support.isExternalized(expression)) {
            ExecutionUtils.run((ObjectInfo)this.m_javaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    String string = value == UNKNOWN_VALUE ? null : (String)value;
                    support.setValue(expression, string);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public Expression getExpression() {
        ExpressionInfo expressionInfo = this.getExpressionInfo();
        return expressionInfo != null ? expressionInfo.m_expression : null;
    }

    @Override
    public void setExpression(String source, Object value) throws Exception {
        ExpressionInfo expressionInfo;
        String[] sourceToValidate = new String[]{source};
        Object[] valueToValidate = new Object[]{value};
        boolean[] validationStatus = new boolean[]{true};
        this.m_javaInfo.getBroadcastJava().setPropertyExpression(this, sourceToValidate, valueToValidate, validationStatus);
        if (!validationStatus[0]) {
            return;
        }
        source = sourceToValidate[0];
        value = valueToValidate[0];
        if (source != null && source.contains("%this%")) {
            source = source.replace("%this%", TemplateUtils.getExpression(this.m_javaInfo));
        }
        if ((expressionInfo = this.getExpressionInfo()) != null) {
            ExpressionAccessor accessor = expressionInfo.m_accessor;
            this.setExpressionUsingAccessor(accessor, source, value);
        } else {
            for (ExpressionAccessor accessor : this.getAccessors()) {
                boolean success = this.setExpressionUsingAccessor(accessor, source, value);
                if (success) break;
            }
        }
        this.rememberValueIntoExpression(value);
        this.m_javaInfo.getBroadcastJava().propertyValueWasSet(this);
    }

    private void rememberValueIntoExpression(Object value) throws Exception {
        Expression expression = this.getExpression();
        if (expression != null && !JavaInfoEvaluationHelper.hasValue(expression)) {
            JavaInfoEvaluationHelper.setValue(expression, value);
        }
    }

    private boolean setExpressionUsingAccessor(ExpressionAccessor accessor, String source, Object value) throws Exception {
        if (value != UNKNOWN_VALUE && Objects.equals(this.getDefaultValue(accessor), value)) {
            source = null;
        }
        return accessor.setExpression(this.m_javaInfo, source);
    }

    private Object getDefaultValue(ExpressionAccessor accessor) throws Exception {
        if (this.m_defaultValue != UNKNOWN_VALUE) {
            return this.m_defaultValue;
        }
        return accessor.getDefaultValue(this.m_javaInfo);
    }

    public Property getComposite(Property[] properties) {
        return GenericPropertyComposite.create(properties);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class) {
            return this.m_accessors[0].getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public List<ExpressionAccessor> getAccessors() {
        ArrayList<ExpressionAccessor> accessors = new ArrayList<ExpressionAccessor>();
        Collections.addAll(accessors, this.m_accessors);
        if (this.m_description != null) {
            this.m_javaInfo.getCreationSupport().addAccessors(this.m_description, accessors);
        }
        Iterator I = accessors.iterator();
        while (I.hasNext()) {
            ExpressionAccessor accessor = (ExpressionAccessor)I.next();
            IAccessibleExpressionAccessor accessibleAccessor = accessor.getAdapter(IAccessibleExpressionAccessor.class);
            if (accessibleAccessor == null || accessibleAccessor.isAccessible(this.m_javaInfo)) continue;
            I.remove();
        }
        return accessors;
    }

    private ExpressionInfo getExpressionInfo() {
        for (ExpressionAccessor accessor : this.getAccessors()) {
            Expression expression = accessor.getExpression(this.m_javaInfo);
            if (expression == null) continue;
            return new ExpressionInfo(accessor, expression);
        }
        return null;
    }

    public String getClipboardSource() throws Exception {
        if (this.m_description != null && this.m_description.hasTrueTag("noClipboard")) {
            return null;
        }
        if (this.m_editor instanceof IClipboardSourceProvider) {
            return ((IClipboardSourceProvider)this.m_editor).getClipboardSource(this);
        }
        if (this.m_converter != null) {
            return this.m_converter.toJavaSource(this.m_javaInfo, this.getValue());
        }
        return null;
    }

    private void setValueEx(Object value) throws Exception {
        String source;
        Object[] valueToValidate = new Object[]{value};
        boolean[] validationStatus = new boolean[]{true};
        ((GenericPropertySetValue)this.m_javaInfo.getBroadcast(GenericPropertySetValue.class)).invoke(this.m_this, valueToValidate, validationStatus);
        if (!validationStatus[0]) {
            return;
        }
        Object validatedValue = valueToValidate[0];
        if (validatedValue == UNKNOWN_VALUE) {
            source = null;
        } else {
            PropertyEditor propertyEditor = this.m_editor;
            if (propertyEditor instanceof IValueSourcePropertyEditor) {
                IValueSourcePropertyEditor sourceEditor = (IValueSourcePropertyEditor)propertyEditor;
                source = sourceEditor.getValueSource(validatedValue);
            } else {
                Assert.isNotNull((Object)this.m_converter, (String)"%s: No converter found for property '%s' of type '%s'", (Object[])new Object[]{ObjectInfo.getText((ObjectInfo)this.getJavaInfo()), this.getTitle(), this.getType()});
                source = this.m_converter.toJavaSource(this.m_javaInfo, validatedValue);
            }
        }
        this.setExpression(source, validatedValue);
        if (value != UNKNOWN_VALUE && !JavaInfoUtils.getState(this.m_javaInfo).isLiveComponent()) {
            NlsSupport.autoExternalize(this.m_this);
        }
    }

    private static final class ExpressionInfo {
        ExpressionAccessor m_accessor;
        Expression m_expression;

        public ExpressionInfo(ExpressionAccessor accessor, Expression expression) {
            this.m_accessor = accessor;
            this.m_expression = expression;
        }
    }
}

