/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import org.eclipse.gef.EditPart;
import org.eclipse.wb.core.gef.policy.validator.BorderOfChildLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.CachingLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.CompatibleLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.ComponentClassLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.ModelClassLayoutRequestValidator;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;

public final class LayoutRequestValidators {
    public static ILayoutRequestValidator modelType(Class<?> requiredModelClass) {
        ILayoutRequestValidator validator = new ModelClassLayoutRequestValidator(requiredModelClass);
        validator = LayoutRequestValidators.cache(validator);
        return LayoutRequestValidators.mixWithMandatory(validator);
    }

    public static ILayoutRequestValidator componentType(String requiredClassName) {
        ILayoutRequestValidator validator = new ComponentClassLayoutRequestValidator(requiredClassName);
        validator = LayoutRequestValidators.cache(validator);
        return LayoutRequestValidators.mixWithMandatory(validator);
    }

    public static ILayoutRequestValidator cache(ILayoutRequestValidator validator) {
        return new CachingLayoutRequestValidator(validator);
    }

    public static ILayoutRequestValidator finalize(ILayoutRequestValidator specificValidator) {
        return LayoutRequestValidators.mixWithMandatory(specificValidator);
    }

    private static ILayoutRequestValidator mixWithMandatory(ILayoutRequestValidator specificValidator) {
        return LayoutRequestValidators.and(BorderOfChildLayoutRequestValidator.INSTANCE, specificValidator, CompatibleLayoutRequestValidator.INSTANCE);
    }

    public static ILayoutRequestValidator and(final ILayoutRequestValidator ... validators) {
        return new ILayoutRequestValidator(){

            @Override
            public boolean validateCreateRequest(EditPart host, CreateRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (!validator.validateCreateRequest(host, request)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean validatePasteRequest(EditPart host, PasteRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (!validator.validatePasteRequest(host, request)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (!validator.validateMoveRequest(host, request)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (!validator.validateAddRequest(host, request)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static ILayoutRequestValidator or(final ILayoutRequestValidator ... validators) {
        return new ILayoutRequestValidator(){

            @Override
            public boolean validateCreateRequest(EditPart host, CreateRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (validator.validateCreateRequest(host, request)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public boolean validatePasteRequest(EditPart host, PasteRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (validator.validatePasteRequest(host, request)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (validator.validateMoveRequest(host, request)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
                ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
                    if (validator.validateAddRequest(host, request)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }
}

