/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.provisional.UIDecorator;

public class CNFManagedUIDecorator
extends UIDecorator {
    private static final String[] serverStateUnmanaged = new String[]{"", Messages.viewStatusStarting4, Messages.viewStatusStarted2, Messages.viewStatusStopping4, Messages.viewStatusStopped2};
    private static Image[] startingImages;
    private static ImageDescriptor[] startingImagesDescriptor;
    private static Image[] stoppingImages;
    private static ImageDescriptor[] stoppingImagesDescriptor;
    private static Image[] startingImagesOverlay;
    private static Image[] stoppingImagesOverlay;

    public void init() {
        this.loadImages();
    }

    public void loadImages() {
        if (startingImages == null) {
            startingImages = new Image[]{ImageResource.getImage("stateStarting1"), ImageResource.getImage("stateStarting2"), ImageResource.getImage("stateStarting3")};
            startingImagesDescriptor = new ImageDescriptor[]{ImageResource.getImageDescriptor("stateStarting1"), ImageResource.getImageDescriptor("stateStarting2"), ImageResource.getImageDescriptor("stateStarting3")};
            stoppingImages = new Image[]{ImageResource.getImage("stateStopping1"), ImageResource.getImage("stateStopping2"), ImageResource.getImage("stateStopping2")};
            stoppingImagesDescriptor = new ImageDescriptor[]{ImageResource.getImageDescriptor("stateStopping1"), ImageResource.getImageDescriptor("stateStopping2"), ImageResource.getImageDescriptor("stateStopping3")};
            startingImagesOverlay = new Image[]{ImageResource.getImage("stateStartingOverlay1"), ImageResource.getImage("stateStartingOverlay2"), ImageResource.getImage("stateStartingOverlay3")};
            stoppingImagesOverlay = new Image[]{ImageResource.getImage("stateStoppingOverlay1"), ImageResource.getImage("stateStoppingOverlay2"), ImageResource.getImage("stateStoppingOverlay2")};
        }
    }

    @Override
    public String getStateLabel(int state, String mode, int count) {
        if (state == 0) {
            return "";
        }
        if (state == 1) {
            return Messages.viewStatusStarting;
        }
        if (state == 3) {
            return Messages.viewStatusStopping;
        }
        if (state == 2) {
            if ("debug".equals(mode)) {
                return Messages.viewStatusStartedDebug;
            }
            if ("profile".equals(mode)) {
                return Messages.viewStatusStartedProfile;
            }
            return Messages.viewStatusStarted;
        }
        if (state == 4) {
            return Messages.viewStatusStopped;
        }
        return serverStateUnmanaged[state];
    }

    @Override
    public Image getStateImage(int state, String mode, int count) {
        this.init();
        if (state == 0) {
            return null;
        }
        if (state == 1) {
            return startingImages[count];
        }
        if (state == 3) {
            return stoppingImages[count];
        }
        if (state == 4) {
            return ImageResource.getImage("stateStopped");
        }
        if ("debug".equals(mode)) {
            return ImageResource.getImage("stateStartedDebug");
        }
        if ("profile".equals(mode)) {
            return ImageResource.getImage("stateStartedProfile");
        }
        return ImageResource.getImage("stateStarted");
    }

    @Override
    public Image getStateImageOverlay(int state, String mode, int count) {
        this.init();
        if (state == 0) {
            return null;
        }
        if (state == 1) {
            return startingImagesOverlay[count];
        }
        if (state == 3) {
            return stoppingImagesOverlay[count];
        }
        if (state == 4) {
            return ImageResource.getImage("stateStoppedOverlay");
        }
        if ("debug".equals(mode)) {
            return ImageResource.getImage("stateStartedDebugOverlay");
        }
        if ("profile".equals(mode)) {
            return ImageResource.getImage("stateStartedProfileOverlay");
        }
        return ImageResource.getImage("stateStartedOverlay");
    }

    @Override
    public ImageDescriptor getStateImageDescriptor(int state, String mode, int count) {
        if (state == 0) {
            return null;
        }
        if (state == 1) {
            return startingImagesDescriptor[count];
        }
        if (state == 3) {
            return stoppingImagesDescriptor[count];
        }
        if (state == 4) {
            return ImageResource.getImageDescriptor("stateStopped");
        }
        if ("debug".equals(mode)) {
            return ImageResource.getImageDescriptor("stateStartedDebug");
        }
        if ("profile".equals(mode)) {
            return ImageResource.getImageDescriptor("stateStartedProfile");
        }
        return ImageResource.getImageDescriptor("stateStarted");
    }

    @Override
    public String getModuleName() {
        return "module";
    }

    @Override
    public boolean canRestart() {
        return true;
    }
}

