/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.set.emfforms.basisattribute.AbstractBasisAttributeEnumeratorRenderer;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasisAttributeBooleanRenderer
extends AbstractBasisAttributeEnumeratorRenderer<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasisAttributeBooleanRenderer.class);
    private static final String NO = "BasisAttributeBooleanRenderer_No";
    private static final String YES = "BasisAttributeBooleanRenderer_Yes";

    public static boolean isApplicable(EClassifier type) {
        return BasisAttributeSetting.isWertFeatureTypeAssignableTo(type, Boolean.class);
    }

    @Inject
    public BasisAttributeBooleanRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(Boolean.class, vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        LOGGER.debug("Render {}", (Object)vElement);
    }

    @Override
    public BasisAttributeSetting<Boolean> getBasisAttributeSetting() {
        return this.basisAttributeSetting;
    }

    @Override
    public Optional<Boolean> valueOf(String representation) {
        return Optional.ofNullable(representation).map(r -> Boolean.parseBoolean(r));
    }

    @Override
    protected List<Object> getInputValues() {
        ArrayList<Object> inputValues = new ArrayList<Object>();
        inputValues.add("<empty value>");
        inputValues.add(Boolean.FALSE);
        inputValues.add(Boolean.TRUE);
        return inputValues;
    }

    @Override
    protected String getLabel(Object element) {
        if (element == "<empty value>") {
            return "";
        }
        if (Boolean.FALSE.equals(element)) {
            return LocalizationServiceHelper.getString(this.getClass(), (String)NO);
        }
        if (Boolean.TRUE.equals(element)) {
            return LocalizationServiceHelper.getString(this.getClass(), (String)YES);
        }
        throw new IllegalArgumentException(element.toString());
    }
}

