/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.exampleservice;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.set.basis.RecentOpenFile;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.core.services.example.ExampleService;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ExampleServiceImpl
implements ExampleService {
    private static final String EXAMPLE_DIR = "examples";
    private List<RecentOpenFile> exampleFiles;
    ToolboxFileService fileService;

    public List<RecentOpenFile> getExampleFiles() {
        if (this.exampleFiles == null) {
            this.exampleFiles = this.findFiles();
        }
        return this.exampleFiles;
    }

    @Reference
    public void setFileService(ToolboxFileService fileService) {
        this.fileService = fileService;
    }

    private List<RecentOpenFile> findFiles() {
        Path pExamplesDir = Paths.get(EXAMPLE_DIR, new String[0]).toAbsolutePath();
        File fExamplesDir = pExamplesDir.toFile();
        String[] examples = fExamplesDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                List extensions = ExampleServiceImpl.this.fileService.extensionsForCategory("ppfile");
                return extensions.contains(PathExtensions.getExtension((Path)Paths.get(name, new String[0])));
            }
        });
        LinkedList<RecentOpenFile> result = new LinkedList<RecentOpenFile>();
        if (examples != null) {
            String[] stringArray = examples;
            int n = examples.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                result.add(new RecentOpenFile(filename, Paths.get(EXAMPLE_DIR, filename)));
                ++n2;
            }
        }
        return result;
    }
}

