/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis;

public class Pair<S, T> {
    private final S first;
    private final T second;

    private static boolean nullSaveEquals(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    public Pair(S first, T second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Pair otherPair = (Pair)other;
        if (!Pair.nullSaveEquals(this.first, otherPair.first)) {
            return false;
        }
        return Pair.nullSaveEquals(this.second, otherPair.second);
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public int hashCode() {
        int result = 17;
        int hashMultiplier = 59;
        int firstHash = this.first == null ? 0 : this.first.hashCode();
        result = result * 59 + firstHash;
        int secondHash = this.second == null ? 0 : this.second.hashCode();
        result = result * 59 + secondHash;
        return result;
    }

    public String toString() {
        return "Pair [first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "]";
    }
}

