/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.export.xsl.AbstractTransformTableHeader;
import org.eclipse.set.utils.export.xsl.TransformTableBody;
import org.eclipse.xtext.xbase.lib.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SinglePageTableHeader
extends AbstractTransformTableHeader {
    protected SinglePageTableHeader(XSSFSheet sheet, float maxPaperWidth) {
        super(sheet, maxPaperWidth);
    }

    @Override
    protected Document getFopPageTemplate() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        return SinglePageTableHeader.parseTemplate("data/export/pdf/table_template.xsl");
    }

    @Override
    protected Pair<Integer, Float> transformColumn(LinkedHashSet<Element> cols, float sumWidth, int colsIndex, int columNumber) {
        float columnWidth = ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, colsIndex);
        cols.add(this.createTableColumn(columNumber, columnWidth));
        return Pair.of((Object)columNumber, (Object)Float.valueOf(sumWidth + columnWidth));
    }

    @Override
    protected int getCellSpanColumn(Optional<Cell> excelCell) {
        if (excelCell.isPresent()) {
            Optional<CellRangeAddress> cellSpanRange = ExcelWorkbookExtension.getColumnSpanRangeAt(excelCell.get());
            return cellSpanRange.isPresent() ? cellSpanRange.get().getNumberOfCells() : 0;
        }
        return 0;
    }

    @Override
    protected void addCell(Set<Element> cells, int rowIndex, Element cell, int cellLastCol) {
        cells.add(cell);
    }

    @Override
    protected void addTableToTemplate(Element tableTemplate, Element table) {
        tableTemplate.appendChild(table);
        Element footNote = this.doc.createElement("xsl:apply-templates");
        footNote.setAttribute("select", "Footnotes");
        tableTemplate.appendChild(footNote);
    }

    @Override
    protected Set<Element> getTableStyle() {
        return new TransformTableBody(this.doc, (Sheet)this.sheet).getDefaultStyles();
    }
}

