/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.widgets;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.set.basis.DomainElementList;
import org.eclipse.set.basis.MediaInfo;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.AttachmentInfo;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.AttachmentContentService;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.basis.observable.ObservableValue;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.utils.Messages;
import org.eclipse.set.utils.attachment.Attachments;
import org.eclipse.set.utils.internal.DomainElementListContentProvider;
import org.eclipse.set.utils.internal.FileKindEditingSupport;
import org.eclipse.set.utils.widgets.ButtonRow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentTable {
    private static final List<ENUMDateityp> unSupportFileFormats = List.of(ENUMDateityp.ENUM_DATEITYP_MPEG, ENUMDateityp.ENUM_DATEITYP_TIF);
    static final Logger logger = LoggerFactory.getLogger(AttachmentTable.class);
    private List<Attachment> attachments = null;
    private final AttachmentContentService contentProvider;
    private List<ToolboxFileFilter> extensions = null;
    private Consumer<Path> attachmentViewer = null;
    private String tempDir;
    private final ToolboxFile toolboxFile;
    DomainElementList<Attachment, AttachmentInfo<Attachment>> attachmentList = null;
    final DialogService dialogService;
    List<FileKind> fileKinds = null;
    final Messages messages;
    ObservableValue<Attachment> selectedAttachment = new ObservableValue();
    Composite tableParent;
    TableViewer viewer;
    private final UserConfigurationService userConfigService;

    private static TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public AttachmentTable(Composite parent, Messages messages, AttachmentContentService contentProvider, DialogService dialogService, ToolboxFile toolboxFile, UserConfigurationService userConfigService) {
        this.tableParent = parent;
        this.messages = messages;
        this.contentProvider = contentProvider;
        this.dialogService = dialogService;
        this.toolboxFile = toolboxFile;
        this.userConfigService = userConfigService;
    }

    public Control createControl() {
        this.createControl(this.getTableParent());
        return this.viewer.getControl();
    }

    public void setExtensionFilter(List<ToolboxFileFilter> extensionFilter) {
        this.extensions = extensionFilter;
    }

    public void setModel(DomainElementList<Attachment, AttachmentInfo<Attachment>> attachmentList, List<FileKind> fileKinds) {
        Assert.isNotNull(fileKinds);
        Assert.isTrue((!fileKinds.isEmpty() ? 1 : 0) != 0);
        this.attachmentList = attachmentList;
        this.fileKinds = fileKinds;
    }

    public void setModel(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setAttachmentViewer(Consumer<Path> attchmentViewer) {
        this.attachmentViewer = attchmentViewer;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void updateModel(List<Attachment> newAttachments) {
        this.attachments.clear();
        newAttachments.forEach(a -> {
            boolean bl = this.attachments.add((Attachment)a);
        });
        this.viewer.refresh();
    }

    private void createButton(ButtonRow buttonRow, String message, final Runnable action, final BooleanSupplier condition) {
        final Button button = buttonRow.add(message);
        button.setEnabled(false);
        Listener selectionListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    action.run();
                }
            }
        };
        button.addListener(13, selectionListener);
        this.selectedAttachment.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                button.setEnabled(AttachmentTable.this.selectedAttachment.getValue().isPresent() && condition.getAsBoolean());
            }
        });
    }

    private void createColumns() {
        String[] titles = new String[]{this.messages.AttachmentTable_columnTitleFilename, this.messages.AttachmentTable_columnTitleFiletype, "", "", ""};
        int[] bounds = new int[]{300, 200};
        this.createFilenameColumn(titles, bounds);
        this.createFileKindColumn(titles, bounds);
    }

    private void createControl(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridData gdTableComposite = new GridData(4, 128, true, true);
        tableComposite.setLayoutData((Object)gdTableComposite);
        tableComposite.setLayout((Layout)new GridLayout());
        Table table = new Table(tableComposite, 67584);
        int tableHeight = table.getItemHeight() * (this.attachments.size() + 1) + table.getHeaderHeight();
        GridData gdTable = new GridData(-1, tableHeight);
        gdTable.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gdTable);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.createColumns();
        if (this.hasSupportForListManipulation()) {
            this.viewer.setContentProvider(new DomainElementListContentProvider());
            this.viewer.setInput(this.attachmentList);
            DomainElementList.ChangeListener changeListener = msg -> this.viewer.refresh();
            this.attachmentList.addChangeListener(changeListener);
            this.viewer.getControl().addDisposeListener(e -> this.attachmentList.removeChangeListener(changeListener));
        } else {
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setInput(this.attachments);
        }
        this.viewer.addSelectionChangedListener(event -> {
            StructuredSelection structuredSelection;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)selection).size() == 1) {
                Object element = structuredSelection.getFirstElement();
                this.selectedAttachment.setValue((Object)((Attachment)element));
            }
        });
        this.createListControls(tableComposite);
    }

    private void createFileKindColumn(String[] titles, int[] bounds) {
        TableViewerColumn col = AttachmentTable.createTableViewerColumn(titles[1], bounds[1], this.viewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Attachment attachment = (Attachment)element;
                return attachment.getFileKind().getTranslation();
            }
        });
        if (this.hasSupportForListManipulation()) {
            col.setEditingSupport((EditingSupport)new FileKindEditingSupport(this.viewer, this.fileKinds));
        }
    }

    private void createFilenameColumn(String[] titles, int[] bounds) {
        TableViewerColumn col = AttachmentTable.createTableViewerColumn(titles[0], bounds[0], this.viewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Attachment attachment = (Attachment)element;
                return attachment.getFullFilename();
            }
        });
    }

    private void createListControls(Composite parent) {
        ButtonRow buttonRow = new ButtonRow(parent);
        this.createButton(buttonRow, this.messages.AttachmentTable_export, () -> this.getSelectedAttachment().ifPresent(attachment -> Attachments.export(this.getTableParent().getShell(), attachment, this.dialogService, this.userConfigService.getLastExportPath(), arg_0 -> ((UserConfigurationService)this.userConfigService).setLastExportPath(arg_0))), () -> true);
        this.createButton(buttonRow, this.messages.AttachmentTable_viewPdf, () -> this.getSelectedAttachment().ifPresent(this::viewAttachment), () -> this.attachmentViewer != null);
        if (this.hasSupportForListManipulation()) {
            this.createButton(buttonRow, this.messages.AttachmentTable_remove, () -> {
                this.getSelectedAttachment().ifPresent(attachment -> this.attachmentList.remove(attachment));
                this.selectedAttachment.setValue(null);
            }, () -> true);
        }
        if (this.hasSupportForListManipulation()) {
            final Button addAttachment = buttonRow.add(this.messages.AttachmentTable_addAttachment);
            addAttachment.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    logger.debug("widgetDefaultSelected");
                    AttachmentTable.this.addAttachment(addAttachment.getShell());
                }

                public void widgetSelected(SelectionEvent e) {
                    logger.debug("widgetSelected");
                    AttachmentTable.this.addAttachment(addAttachment.getShell());
                }
            });
            buttonRow.getComposite().setLayoutData((Object)new GridData(131072, 1024, false, false));
        }
    }

    private boolean hasSupportForListManipulation() {
        return this.attachmentList != null;
    }

    private void saveAttachment(Attachment attachment, Path path) throws IOException {
        byte[] content = this.contentProvider.getContent(attachment);
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.write(path, content, new OpenOption[0]);
    }

    private void startAttachmentViewer(Path path) {
        String extension = PathExtensions.getExtension((Path)path);
        ENUMDateityp enumDateityp = ENUMDateityp.get((String)extension);
        if (unSupportFileFormats.contains(enumDateityp)) {
            this.dialogService.openInformation(this.tableParent.getShell(), this.messages.AttachmentTable_UnsupportFormatTitle, this.messages.AttachmentTable_UnsupportFormatMsg);
            return;
        }
        if (this.attachmentViewer != null) {
            this.attachmentViewer.accept(path);
        }
    }

    void addAttachment(Shell shell) {
        logger.debug("addAttachment");
        try {
            Attachment loadedAttachment = Attachments.load(shell, this.fileKinds.get(0), this.dialogService, this.extensions);
            if (loadedAttachment != null) {
                AttachmentInfo loadedAttachmentInfo = new AttachmentInfo();
                loadedAttachmentInfo.setElement((Object)loadedAttachment);
                loadedAttachmentInfo.setData(loadedAttachment.getData());
                loadedAttachmentInfo.setToolboxFile(this.toolboxFile);
                loadedAttachmentInfo.setGuidProvider(a -> Guid.create((String)a.getId()));
                this.attachmentList.add((MediaInfo)loadedAttachmentInfo);
            }
        }
        catch (ToolboxFileFilter.InvalidFilterFilename e) {
            this.dialogService.error(shell, (Exception)((Object)e));
        }
    }

    Optional<Attachment> getSelectedAttachment() {
        return this.selectedAttachment.getValue();
    }

    void viewAttachment(Attachment attachment) {
        Path path = Paths.get(this.tempDir, attachment.getId(), attachment.getFullFilename());
        try {
            this.saveAttachment(attachment, path);
            this.startAttachmentViewer(path);
        }
        catch (IOException e) {
            this.dialogService.error(this.viewer.getControl().getShell(), this.messages.AttachmentTable_MissingBinaryDataMsg);
        }
    }

    public Composite getTableParent() {
        return this.tableParent;
    }
}

