/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.wikitext.ui.util.IOUtil;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.ui.commands.AbstractMarkupResourceHandler;
import org.eclipse.mylyn.wikitext.ui.commands.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertMarkupToHtml
extends AbstractMarkupResourceHandler {
    @Override
    protected void handleFile(IFile file, String name) {
        IFile newFile = file.getParent().getFile((IPath)new Path(name + ".html"));
        if (newFile.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToHtml_overwrite, (String)NLS.bind((String)Messages.ConvertMarkupToHtml_fileExistsOverwrite, (Object[])new Object[]{newFile.getFullPath()}))) {
            return;
        }
        StringWriter writer = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer, true);
        MarkupParser parser = new MarkupParser();
        parser.setMarkupLanguage(this.markupLanguage);
        parser.setBuilder((DocumentBuilder)builder);
        builder.setEmitDtd(true);
        try {
            IRunnableWithProgress runnable = monitor -> {
                try {
                    String inputContent = IOUtil.readFully(file);
                    parser.parse(inputContent);
                    String xhtmlContent = writer.toString();
                    if (newFile.exists()) {
                        newFile.setContents((InputStream)new ByteArrayInputStream(xhtmlContent.getBytes(StandardCharsets.UTF_8)), false, true, monitor);
                    } else {
                        newFile.create((InputStream)new ByteArrayInputStream(xhtmlContent.getBytes(StandardCharsets.UTF_8)), false, monitor);
                    }
                    newFile.setCharset(StandardCharsets.UTF_8.name(), monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            StringWriter message = new StringWriter();
            Throwable throwable = null;
            Object var10_14 = null;
            try (PrintWriter out = new PrintWriter(message);){
                out.println(Messages.ConvertMarkupToHtml_cannotConvert + e.getMessage());
                out.println(Messages.ConvertMarkupToHtml_detailsFollow);
                e.printStackTrace(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToHtml_cannotCompleteOperation, (String)message.toString());
        }
    }
}

