/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsElementScanner;

public class SuppressionsContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<CompletionProposal> completions = new ArrayList<CompletionProposal>();
        IDocument doc = viewer.getDocument();
        try {
            String[] words;
            String prefix = this.completionWord(doc, offset);
            int replacementOffset = offset;
            int replacementLength = 0;
            if (prefix != null) {
                replacementLength = prefix.length();
                replacementOffset -= replacementLength;
            }
            String toolName = this.getToolName(doc, replacementOffset);
            for (String word : words = this.getCompletionStrings(prefix, toolName)) {
                completions.add(new CompletionProposal(word, replacementOffset, replacementLength, word.length()));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private String completionWord(IDocument doc, int offset) throws BadLocationException {
        String word = null;
        if (offset > 0) {
            for (int n = offset - 1; n >= 0 && word == null; --n) {
                char c = doc.getChar(n);
                if (!Character.isLetterOrDigit(c)) {
                    word = doc.get(n + 1, offset - n - 1);
                    continue;
                }
                if (n != 0) continue;
                word = doc.get(0, offset - n);
            }
        }
        return word;
    }

    private String[] getCompletionStrings(String prefix, String toolName) {
        ArrayList<Object> words = new ArrayList<Object>();
        if (toolName != null && toolName.equals("Memcheck")) {
            for (String word : SuppressionsElementScanner.MEMCHECK_SUPP_TYPES) {
                if (prefix != null && !word.startsWith(prefix)) continue;
                words.add(word);
            }
        } else {
            if (prefix == null || "Memcheck".startsWith(prefix)) {
                words.add("Memcheck:");
            }
            for (String word : SuppressionsElementScanner.CONTEXTS) {
                if (prefix != null && !word.startsWith(prefix)) continue;
                words.add(word + ":");
            }
        }
        return words.toArray(new String[words.size()]);
    }

    private String getToolName(IDocument doc, int offset) throws BadLocationException {
        char c;
        String tool = null;
        if (offset > 0 && (c = doc.getChar(--offset)) == ':' && offset > 0) {
            for (int n = offset - 1; n >= 0 && tool == null; --n) {
                c = doc.getChar(n);
                if (!Character.isLetter(c)) {
                    tool = doc.get(n + 1, offset - n - 1);
                    continue;
                }
                if (n != 0) continue;
                tool = doc.get(0, offset - n);
            }
        }
        return tool;
    }
}

