/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Iterables;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LoopExtensions {
    public <T> void forEach(ITreeAppendable appendable, Iterable<T> elements, Procedures.Procedure1<? super LoopParams> loopInitializer, Procedures.Procedure1<? super T> procedure) {
        if (Iterables.isEmpty(elements)) {
            return;
        }
        LoopParams params = new LoopParams();
        loopInitializer.apply((Object)params);
        params.appendPrefix(appendable);
        procedure.apply(Iterables.getFirst(elements, null));
        IterableExtensions.tail(elements).forEach(it -> {
            params.appendSeparator(appendable);
            procedure.apply(it);
        });
        params.appendSuffix(appendable);
    }

    public <T> void forEachWithShortcut(ITreeAppendable appendable, Iterable<T> elements, Procedures.Procedure1<? super T> procedure) {
        if (IterableExtensions.size(elements) == 1) {
            procedure.apply(Iterables.getFirst(elements, null));
        } else {
            appendable.append("{");
            this.forEach(appendable, elements, (Procedures.Procedure1<? super LoopParams>)((Procedures.Procedure1)it -> {
                it.setPrefix(" ");
                it.setSeparator(", ");
                it.setSuffix(" ");
            }), procedure);
            appendable.append("}");
        }
    }
}

