/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gef.dot.internal.DotFileUtils;

public class DotExtractor {
    private final String NO_DOT = "graph{n1[label=\"no DOT\"]}";
    private String input = "graph{n1[label=\"no DOT\"]}";

    public DotExtractor(String input) {
        this.input = input;
    }

    public DotExtractor(File file) {
        this(DotFileUtils.read(file));
    }

    public String getDotString() {
        return this.trimNonDotSuffix(this.trimNonDotPrefix());
    }

    public File getDotTempFile() {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempDotExtractorFile", ".dot");
        }
        catch (IOException e) {
            System.err.println("DotExtractor failed to create temp dot file");
            e.printStackTrace();
        }
        if (tempFile != null) {
            try {
                Throwable e = null;
                Object var3_6 = null;
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));){
                    bw.write(this.getDotString());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }

    private String trimNonDotPrefix() {
        Matcher m = Pattern.compile("((?:di)?graph\\s*[^{\\s]*\\s*\\{.+)", 32).matcher(this.input);
        String dotSubstring = m.find() ? m.group(1) : "graph{n1[label=\"no DOT\"]}";
        return dotSubstring;
    }

    private String trimNonDotSuffix(String dot) {
        int first = dot.indexOf(123) + 1;
        StringBuilder builder = new StringBuilder(dot.substring(0, first));
        int count = 1;
        int index = first;
        while (count > 0 && index < dot.length()) {
            char c = dot.charAt(index);
            builder.append(c);
            count = c == '{' ? count + 1 : (c == '}' ? count - 1 : count);
            ++index;
        }
        return builder.toString().trim();
    }
}

