/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.gef.common.collections.CollectionUtils;

public class ListListenerHelperEx<E> {
    private List<InvalidationListener> invalidationListeners = null;
    private boolean lockInvalidationListeners;
    private boolean lockListChangeListeners;
    private List<ListChangeListener<? super E>> listChangeListeners = null;
    private ObservableList<E> source;

    protected static <E> List<ElementarySubChange<E>> getElementaryChanges(ListChangeListener.Change<? extends E> change) {
        ArrayList elementarySubChanges = new ArrayList();
        while (change.next()) {
            if (change.wasReplaced()) {
                elementarySubChanges.add(ElementarySubChange.replaced(change.getRemoved(), change.getAddedSubList(), change.getFrom(), change.getTo()));
                continue;
            }
            if (change.wasRemoved()) {
                elementarySubChanges.add(ElementarySubChange.removed(change.getRemoved(), change.getFrom(), change.getTo()));
                continue;
            }
            if (change.wasAdded()) {
                elementarySubChanges.add(ElementarySubChange.added(new ArrayList(change.getAddedSubList()), change.getFrom(), change.getTo()));
                continue;
            }
            if (!change.wasPermutated()) continue;
            int[] permutation = CollectionUtils.getPermutation(change);
            elementarySubChanges.add(ElementarySubChange.permutated(permutation, change.getFrom(), change.getTo()));
        }
        change.reset();
        return elementarySubChanges;
    }

    public ListListenerHelperEx(ObservableList<E> source) {
        this.source = source;
    }

    public void addListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new ArrayList<InvalidationListener>();
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        this.invalidationListeners.add(listener);
    }

    public void addListener(ListChangeListener<? super E> listener) {
        if (this.listChangeListeners == null) {
            this.listChangeListeners = new ArrayList<ListChangeListener<? super E>>();
        }
        if (this.lockListChangeListeners) {
            this.listChangeListeners = new ArrayList<ListChangeListener<ListChangeListener<? super E>>>(this.listChangeListeners);
        }
        this.listChangeListeners.add(listener);
    }

    public void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        this.notifyInvalidationListeners();
        if (change != null) {
            this.notifyListChangeListeners(change);
        }
    }

    protected ObservableList<E> getSource() {
        return this.source;
    }

    protected void notifyInvalidationListeners() {
        if (this.invalidationListeners != null) {
            try {
                this.lockInvalidationListeners = true;
                for (InvalidationListener l : this.invalidationListeners) {
                    try {
                        l.invalidated(this.source);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockInvalidationListeners = false;
            }
        }
    }

    protected void notifyListChangeListeners(ListChangeListener.Change<? extends E> change) {
        if (this.listChangeListeners != null) {
            try {
                this.lockListChangeListeners = true;
                for (ListChangeListener<? super E> listChangeListener : this.listChangeListeners) {
                    change.reset();
                    try {
                        listChangeListener.onChanged(change);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockListChangeListeners = false;
            }
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            return;
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        Iterator<InvalidationListener> iterator = this.invalidationListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.invalidationListeners.isEmpty()) {
            this.invalidationListeners = null;
        }
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        if (this.listChangeListeners == null) {
            return;
        }
        if (this.lockListChangeListeners) {
            this.listChangeListeners = new ArrayList<ListChangeListener<ListChangeListener<? super E>>>(this.listChangeListeners);
        }
        Iterator<ListChangeListener<E>> iterator = this.listChangeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.listChangeListeners.isEmpty()) {
            this.listChangeListeners = null;
        }
    }

    public static class AtomicChange<E>
    extends ListChangeListener.Change<E> {
        private int cursor = -1;
        private ElementarySubChange<E>[] elementarySubChanges;
        private List<E> previousContents;

        public AtomicChange(ObservableList<E> source, List<E> previousContents, ElementarySubChange<E> elementarySubChange) {
            super(source);
            this.previousContents = previousContents;
            this.elementarySubChanges = new ElementarySubChange[]{elementarySubChange};
        }

        public AtomicChange(ObservableList<E> source, List<E> previousContents, List<ElementarySubChange<E>> elementarySubChanges) {
            super(source);
            this.previousContents = previousContents;
            this.elementarySubChanges = elementarySubChanges.toArray(new ElementarySubChange[0]);
        }

        public AtomicChange(ObservableList<E> source, ListChangeListener.Change<? extends E> change) {
            super(source);
            this.previousContents = new ArrayList<E>(CollectionUtils.getPreviousContents(change));
            List<ElementarySubChange<E>> elementarySubChanges = ListListenerHelperEx.getElementaryChanges(change);
            this.elementarySubChanges = elementarySubChanges.toArray(new ElementarySubChange[0]);
        }

        public int getAddedSize() {
            return super.getAddedSize();
        }

        public List<E> getAddedSubList() {
            return this.elementarySubChanges[this.cursor].getAdded();
        }

        public int getFrom() {
            return this.elementarySubChanges[this.cursor].getFrom();
        }

        public int[] getPermutation() {
            return this.elementarySubChanges[this.cursor].getPermutation();
        }

        public int getPermutation(int i) {
            return super.getPermutation(i);
        }

        public List<E> getPreviousContents() {
            return Collections.unmodifiableList(this.previousContents);
        }

        public List<E> getRemoved() {
            return this.elementarySubChanges[this.cursor].getRemoved();
        }

        public int getRemovedSize() {
            return super.getRemovedSize();
        }

        public int getTo() {
            return this.elementarySubChanges[this.cursor].getTo();
        }

        public boolean next() {
            ++this.cursor;
            return this.cursor < this.elementarySubChanges.length;
        }

        public void reset() {
            this.cursor = -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.elementarySubChanges.length) {
                sb.append(this.elementarySubChanges[i].toString());
                if (i < this.elementarySubChanges.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            return sb.toString();
        }

        public boolean wasAdded() {
            return !this.getAddedSubList().isEmpty();
        }

        public boolean wasPermutated() {
            return super.wasPermutated();
        }

        public boolean wasRemoved() {
            return super.wasRemoved();
        }

        public boolean wasReplaced() {
            return super.wasReplaced();
        }

        public boolean wasUpdated() {
            return super.wasUpdated();
        }
    }

    public static class ElementarySubChange<E> {
        private Kind kind;
        private List<E> removed;
        private List<E> added;
        private int from;
        private int to;
        private int[] permutation;

        public static <E> ElementarySubChange<E> added(List<? extends E> added, int from, int to) {
            return new ElementarySubChange<E>(Kind.ADD, from, to, null, added, null);
        }

        public static <E> ElementarySubChange<E> permutated(int[] permutation, int from, int to) {
            return new ElementarySubChange<E>(Kind.PERMUTATE, from, to, null, null, permutation);
        }

        public static <E> ElementarySubChange<E> removed(List<? extends E> removed, int from, int to) {
            return new ElementarySubChange<E>(Kind.REMOVE, from, to, removed, null, null);
        }

        public static <E> ElementarySubChange<E> replaced(List<? extends E> removed, List<? extends E> added, int from, int to) {
            return new ElementarySubChange<E>(Kind.REPLACE, from, to, removed, added, null);
        }

        public ElementarySubChange(Kind kind, int from, int to, List<? extends E> removed, List<? extends E> added, int[] permutation) {
            this.kind = kind;
            this.from = from;
            this.to = to;
            if (removed != null) {
                this.removed = new ArrayList<E>(removed);
            }
            if (added != null) {
                this.added = new ArrayList<E>(added);
            }
            if (permutation != null) {
                this.permutation = permutation;
            }
        }

        public List<E> getAdded() {
            if (this.added == null) {
                return Collections.emptyList();
            }
            return this.added;
        }

        public int getFrom() {
            return this.from;
        }

        public Kind getKind() {
            return this.kind;
        }

        public int[] getPermutation() {
            if (this.permutation == null) {
                return new int[0];
            }
            return this.permutation;
        }

        public List<E> getRemoved() {
            if (this.removed == null) {
                return Collections.emptyList();
            }
            return this.removed;
        }

        public int getTo() {
            return this.to;
        }

        public String toString() {
            if (Kind.REPLACE.equals((Object)this.kind)) {
                return "Replaced" + this.getRemoved() + " by " + this.getAdded() + " at " + this.getFrom() + ".";
            }
            if (Kind.ADD.equals((Object)this.kind)) {
                return "Added" + this.getAdded() + " at " + this.getFrom() + ".";
            }
            if (Kind.REMOVE.equals((Object)this.kind)) {
                return "Removed" + this.getRemoved() + " at " + this.getFrom() + ".";
            }
            if (Kind.PERMUTATE.equals((Object)this.kind)) {
                return "Permutated by " + Arrays.toString(this.getPermutation()) + ".";
            }
            return super.toString();
        }

        public static enum Kind {
            ADD,
            REMOVE,
            REPLACE,
            PERMUTATE;

        }
    }
}

