/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.AbstractEnvironmentFactory;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLEvaluationEnvironment;
import org.eclipse.ocl.uml.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.uml.util.OCLUMLUtil;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLEnvironmentFactory
extends AbstractEnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> {
    private final EPackage.Registry registry;
    private final ResourceSet resourceSet;
    private Package umlMetamodel;
    private Map<EClass, Classifier> eclassToClassifierMap = new HashMap<EClass, Classifier>();
    private Map<List<String>, Package> packageCache = new HashMap<List<String>, Package>();

    public UMLEnvironmentFactory() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public UMLEnvironmentFactory(ResourceSet rset) {
        this(rset.getPackageRegistry(), rset);
    }

    public UMLEnvironmentFactory(EPackage.Registry registry, ResourceSet rset) {
        this.registry = registry;
        this.resourceSet = rset;
    }

    public UMLEnvironment createEnvironment() {
        UMLEnvironment result = new UMLEnvironment(this.registry, this.resourceSet);
        result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
        return result;
    }

    public Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> loadEnvironment(Resource resource) {
        UMLEnvironment result = new UMLEnvironment(this.registry, this.resourceSet, resource);
        result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
        return result;
    }

    public final EPackage.Registry getEPackageRegistry() {
        return this.registry;
    }

    public final ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected Package getUMLMetamodel() {
        if (this.umlMetamodel == null) {
            this.umlMetamodel = OCLUMLUtil.getUMLMetamodel(this.getResourceSet());
        }
        return this.umlMetamodel;
    }

    protected Package lookupPackage(List<String> pathname) {
        Package result = this.packageCache.get(pathname);
        if (result == null) {
            result = OCLUMLUtil.findPackage(pathname, this.resourceSet);
            this.packageCache.put(pathname, result);
        }
        return result;
    }

    protected Classifier getClassifier(Object context) {
        Classifier result;
        if (context instanceof InstanceSpecification) {
            InstanceSpecification instance = (InstanceSpecification)context;
            result = !instance.getClassifiers().isEmpty() ? (Classifier)instance.getClassifiers().get(0) : OCLStandardLibraryImpl.INSTANCE.getOclAny();
        } else if (context instanceof ValueSpecification) {
            result = context instanceof InstanceValue ? this.getClassifier(((InstanceValue)context).getInstance()) : (context instanceof LiteralBoolean ? OCLStandardLibraryImpl.INSTANCE.getBoolean() : (context instanceof LiteralString ? OCLStandardLibraryImpl.INSTANCE.getString() : (context instanceof LiteralInteger ? OCLStandardLibraryImpl.INSTANCE.getInteger() : OCLStandardLibraryImpl.INSTANCE.getOclAny())));
        } else if (context instanceof EObject) {
            EClass eclass = ((EObject)context).eClass();
            result = this.eclassToClassifierMap.get(eclass);
            if (result == null) {
                result = OCLUMLUtil.getClassifier((EClassifier)eclass, this.resourceSet);
                if (result == null) {
                    result = OCLStandardLibraryImpl.INSTANCE.getOclAny();
                }
                this.eclassToClassifierMap.put(eclass, result);
            }
        } else {
            result = context instanceof String ? OCLStandardLibraryImpl.INSTANCE.getString() : (context instanceof Boolean ? OCLStandardLibraryImpl.INSTANCE.getBoolean() : (context instanceof Integer ? OCLStandardLibraryImpl.INSTANCE.getInteger() : (context instanceof Double ? OCLStandardLibraryImpl.INSTANCE.getReal() : OCLStandardLibraryImpl.INSTANCE.getOclAny())));
        }
        return result;
    }

    public Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> createEnvironment(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> parent) {
        if (!(parent instanceof UMLEnvironment)) {
            throw new IllegalArgumentException("Parent environment must be a UML environment: " + parent);
        }
        UMLEnvironment result = new UMLEnvironment(parent);
        result.setFactory((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
        return result;
    }

    public EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> createEvaluationEnvironment() {
        return new UMLEvaluationEnvironment(this);
    }

    public EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> createEvaluationEnvironment(EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> parent) {
        return new UMLEvaluationEnvironment(parent);
    }

    public OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this);
    }

    public OCL createOCL(Resource resource) {
        return OCL.newInstance((EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject>)this, resource);
    }
}

