/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.internal.debug.ui.DebugUiPlugin;
import org.eclipse.osgi.util.NLS;

public class BreakpointsStructureBridge
extends AbstractContextStructureBridge {
    private static final String ATTRIBUTE_ID_DEFAULT = "breakpoint[unknown]";
    static final String ATTRIBUTE_ID = "org.eclipse.mylyn.debug.ui.breakpointId";
    public static final String HANDLE_DEFAULT_BREAKPOINT_MANAGER = "breakpointmanager[default]";
    private final IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();

    public String getContentType() {
        return "breakpoint";
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof IBreakpoint) {
            IBreakpoint breakpoint = (IBreakpoint)object;
            this.updateBreakpointId((IBreakpoint)object);
            return breakpoint.getMarker().getAttribute(ATTRIBUTE_ID, ATTRIBUTE_ID_DEFAULT);
        }
        if (object instanceof IBreakpointManager) {
            return HANDLE_DEFAULT_BREAKPOINT_MANAGER;
        }
        return null;
    }

    private void updateBreakpointId(IBreakpoint object) {
        if (object.getMarker().getAttribute(ATTRIBUTE_ID, null) == null) {
            try {
                object.getMarker().setAttribute(ATTRIBUTE_ID, (Object)("breakpoint[" + Math.random() * 10000.0 + "]"));
            }
            catch (CoreException e) {
                IResource resource = object.getMarker().getResource();
                StatusHandler.log((IStatus)new Status(2, DebugUiPlugin.ID_PLUGIN, NLS.bind((String)"Breakpoint could not be updated for resource {0} ", (Object)resource.getFullPath())));
            }
        }
    }

    public String getParentHandle(String handle) {
        Object object = this.getObjectForHandle(handle);
        if (object != null && object instanceof IBreakpoint) {
            return HANDLE_DEFAULT_BREAKPOINT_MANAGER;
        }
        return null;
    }

    public Object getObjectForHandle(String handle) {
        if (handle.equals(HANDLE_DEFAULT_BREAKPOINT_MANAGER)) {
            return this.breakpointManager;
        }
        IBreakpoint[] iBreakpointArray = this.breakpointManager.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint.getMarker().getAttribute(ATTRIBUTE_ID, ATTRIBUTE_ID_DEFAULT).equals(handle)) {
                return breakpoint;
            }
            ++n2;
        }
        return null;
    }

    public List<String> getChildHandles(String handle) {
        return Collections.emptyList();
    }

    public String getLabel(Object object) {
        return object.toString();
    }

    public boolean canBeLandmark(String handle) {
        return true;
    }

    public boolean acceptsObject(Object object) {
        return object instanceof IBreakpointManager || object instanceof IBreakpoint;
    }

    public boolean canFilter(Object element) {
        return true;
    }

    public boolean isDocument(String handle) {
        return false;
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        return null;
    }

    public String getContentType(String elementHandle) {
        Object object = this.getObjectForHandle(elementHandle);
        if (object != null) {
            return "breakpoint";
        }
        return null;
    }
}

