/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ui;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.SnapToAllDragEditPartsTracker;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.MoveInDiagramDragTracker;
import org.eclipse.swt.events.MouseEvent;

public class SiriusDragEditPartsTrackerEx
extends SnapToAllDragEditPartsTracker
implements MoveInDiagramDragTracker {
    private static final int X_MARGIN = 30;
    private static final int Y_MARGIN = 30;
    private Point previousMouseLocation;

    public SiriusDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    @Override
    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getAdaptedMouseLocation(), this.getExclusionSet(), this.getTargetingConditional());
            if (editPart != null) {
                editPart = editPart.getTargetEditPart(this.getTargetRequest());
            }
            boolean changed = this.getTargetEditPart() != editPart;
            this.setTargetEditPart(editPart);
            return changed;
        }
        return false;
    }

    protected EditPart getSourceParentEditPart() {
        EditPart parent = this.getSourceEditPart().getParent();
        return parent;
    }

    protected boolean hasToAdaptMouseLocation(Rectangle parentBounds, Point mouseLocation) {
        Rectangle boundsAndMargins = parentBounds.getExpanded(30, 30);
        return boundsAndMargins.contains(mouseLocation) && !parentBounds.contains(mouseLocation);
    }

    protected Point getAdaptedMouseLocation() {
        Point mouseAdaptedLocation;
        Point mouseRealLocation;
        Rectangle parentBounds = this.getAbsoluteSourceParentBounds();
        if (this.hasToAdaptMouseLocation(parentBounds, mouseRealLocation = super.getLocation())) {
            Point center = parentBounds.getCenter();
            Dimension rectangleDimension = parentBounds.getSize();
            double xLocation = this.getAdaptedMouseXLocation(mouseRealLocation.x, center.x, rectangleDimension.width);
            double yLocation = this.getAdaptedMouseYLocation(mouseRealLocation.y, center.y, rectangleDimension.height);
            mouseAdaptedLocation = new PrecisionPoint(xLocation, yLocation);
        } else {
            mouseAdaptedLocation = mouseRealLocation.getCopy();
        }
        return mouseAdaptedLocation;
    }

    private Rectangle getAbsoluteSourceParentBounds() {
        EditPart parent = this.getSourceParentEditPart();
        Rectangle absoluteBounds = ((GraphicalEditPart)parent).getFigure().getBounds().getCopy();
        ((GraphicalEditPart)parent).getFigure().translateToAbsolute((Translatable)absoluteBounds);
        return absoluteBounds;
    }

    private double getAdaptedMouseXLocation(int xMouseLocation, int xCenter, double width) {
        return this.getAdaptedMouseCoordinateLocation(xMouseLocation, xCenter, width, 30);
    }

    private double getAdaptedMouseYLocation(int yMouseLocation, int yCenter, double height) {
        return this.getAdaptedMouseCoordinateLocation(yMouseLocation, yCenter, height, 30);
    }

    private double getAdaptedMouseCoordinateLocation(int mouseLocation, int center, double length, int delta) {
        double halfLength = length / 2.0;
        double result = (double)center + halfLength / (halfLength + (double)delta) * (double)(mouseLocation - center);
        return result;
    }

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        if (this.getTargetRequest() instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest targetRequest = (ChangeBoundsRequest)this.getTargetRequest();
            targetRequest.setLocation(this.getAdaptedMouseLocation());
        }
    }

    protected void setCloneActive(boolean cloneActive) {
        super.setCloneActive(false);
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (button == 2) {
            this.setCursor(SharedCursors.HAND);
            return this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    @Override
    protected boolean handleButtonUp(int button) {
        boolean result = false;
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.performDrag();
            result = true;
        } else if (this.isInState(2)) {
            this.performSelection();
            if (this.getFlag(128)) {
                this.performDirectEdit();
            }
            this.setState(0x40000000);
            result = true;
        }
        this.snapToAllShape = false;
        return result;
    }

    @Override
    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        this.previousMouseLocation = this.getCurrentInput().getMouseLocation().getCopy();
        super.mouseDrag(me, viewer);
    }

    @Override
    protected boolean handleDragStarted() {
        if (this.isInState(64)) {
            return this.stateTransition(64, 128);
        }
        return super.handleDragStarted();
    }

    @Override
    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)this.getCurrentViewer().getControl();
                Point currentMouseLocation = this.getCurrentInput().getMouseLocation();
                Dimension difference = this.previousMouseLocation.getDifference(currentMouseLocation);
                Point location = figureCanvas.getViewport().getViewLocation();
                figureCanvas.scrollTo(location.x + difference.width, location.y + difference.height);
            }
            return true;
        }
        return super.handleDragInProgress();
    }

    protected void reveal(EditPart editpart) {
        if (editpart.getRoot() != null) {
            super.reveal(editpart);
        }
    }
}

