/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.resources;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.oomph.internal.resources.Messages;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class FileExtractMatchingPatternResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        return new Evaluator(variable, argument).evaluate();
    }

    private static class Evaluator {
        private final IDynamicVariable variable;
        private final String argument;

        public Evaluator(IDynamicVariable variable, String argument) {
            this.variable = variable;
            this.argument = argument;
        }

        public String evaluate() throws CoreException {
            if (this.argument == null) {
                throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_UnspecifedArguments_exception, (Object)this.variable()), null);
            }
            StringBuilder result = new StringBuilder();
            String[] arguments = this.argument.split("(?<!\\\\),", -1);
            Path path = this.path(this.argument(arguments, 0));
            String content = this.read(path, this.charset(this.argument(arguments, 1)));
            Pattern pattern = this.pattern(this.argument(arguments, 2));
            String defaultValue = this.argument(arguments, 4);
            String substitution = this.argument(arguments, 3);
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                matcher = pattern.matcher(content.substring(matcher.start()));
                matcher.find();
                matcher.appendReplacement(result, substitution);
            } else {
                result.append(defaultValue);
            }
            return result.toString();
        }

        private String decode(String value) {
            return value.replace("\\,", ",");
        }

        private Pattern pattern(String pattern) throws CoreException {
            if (pattern.isBlank()) {
                throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_InvalidBlankPattern_exception, (Object)this.variable(), (Object)pattern), null);
            }
            try {
                return Pattern.compile(pattern);
            }
            catch (Exception ex) {
                throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_InvalidPattern_exception, (Object)this.variable(), (Object)pattern), ex);
            }
        }

        private String read(Path path, Charset charset) throws CoreException {
            try {
                return Files.readString(path, charset);
            }
            catch (IOException ex) {
                throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_InvalidRead_excpetion, (Object)this.variable(), (Object)path), null);
            }
        }

        private String argument(String[] arguments, int i) throws CoreException {
            if (i < arguments.length) {
                return this.decode(arguments[i]);
            }
            throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_MissingArgument_exception, (Object)this.variable(), (Object)(i + 1)), null);
        }

        private Charset charset(String charset) throws CoreException {
            try {
                return Charset.forName(charset);
            }
            catch (Exception ex) {
                throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_InvalidCharset_exception, (Object)this.variable(), (Object)charset), ex);
            }
        }

        private Path path(String path) throws CoreException {
            try {
                return Path.of(path, new String[0]);
            }
            catch (Exception ex) {
                throw this.coreException(NLS.bind((String)Messages.FileExtractMatchingPatternResolver_InvalidPath_exception, (Object)this.variable(), (Object)path), ex);
            }
        }

        /*
         * Unable to fully structure code
         */
        private CoreException coreException(String message, Throwable throwable) throws CoreException {
            try {
                if (throwable != null) {
                    exceptionMessage = throwable.getLocalizedMessage();
                    if ((exceptionMessage == null || exceptionMessage.isBlank()) && ((exceptionMessage = throwable.getMessage()) == null || exceptionMessage.isBlank())) {
                        exceptionMessage = throwable.getClass().getSimpleName();
                    }
                    throw new CoreException((IStatus)new Status(4, this.getClass(), message + ":\n  " + exceptionMessage.replaceAll(":$", ""), throwable));
                }
                throw new CoreException((IStatus)new Status(4, this.getClass(), message));
            }
            catch (CoreException ex) {
                var7_5 = Thread.currentThread().getStackTrace();
                var6_6 = var7_5.length;
                var5_7 = 0;
                ** while (var5_7 < var6_6)
            }
lbl-1000:
            // 1 sources

            {
                stackTraceElement = var7_5[var5_7];
                if ("getProgramArguments".equals(stackTraceElement.getMethodName()) && "org.eclipse.m2e.internal.launch.MavenLaunchDelegate".equals(stackTraceElement.getClassName())) {
                    ResourcesPlugin.INSTANCE.log(ex.getStatus());
                }
                ++var5_7;
                continue;
            }
lbl18:
            // 1 sources

            throw ex;
        }

        private String variable() {
            return "${" + this.variable.getName() + (String)(this.argument == null ? "" : ":" + this.argument) + "}";
        }
    }
}

