/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.blame.BlameInformationControl;
import org.eclipse.egit.ui.internal.blame.BlameRevision;
import org.eclipse.egit.ui.internal.components.EditorVisibilityTracker;
import org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class BlameOperation
implements IEGitOperation {
    private static final String QUICKDIFF_PROVIDER_ID = GitQuickDiffProvider.class.getName();
    private Repository repository;
    private CommitFileRevision fileRevision;
    private IStorage storage;
    private String path;
    private RevCommit startCommit;
    private Shell shell;
    private IWorkbenchPage page;
    private int lineNumberToReveal = -1;

    public BlameOperation(Repository repository, IFile storage, String path, RevCommit startCommit, Shell shell, IWorkbenchPage page) {
        this.repository = repository;
        this.storage = storage;
        this.path = path;
        this.startCommit = startCommit;
        this.shell = shell;
        this.page = page;
        this.lineNumberToReveal = -1;
    }

    public BlameOperation(CommitFileRevision revision, Shell shell, IWorkbenchPage page) {
        this(revision, shell, page, -1);
    }

    public BlameOperation(CommitFileRevision revision, Shell shell, IWorkbenchPage page, int lineNumberToReveal) {
        this.fileRevision = revision;
        this.repository = revision.getRepository();
        this.path = revision.getGitPath();
        this.startCommit = revision.getRevCommit();
        this.shell = shell;
        this.page = page;
        this.lineNumberToReveal = lineNumberToReveal;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        RevisionInformation info;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ObjectId currentHead = null;
        if (this.startCommit != null) {
            info = BlameOperation.computeRevisions(this.repository, (ObjectId)this.startCommit, this.path, (IProgressMonitor)progress.newChild(2));
        } else {
            try {
                currentHead = this.repository.resolve("HEAD");
            }
            catch (IOException e) {
                Activator.error("Error resolving HEAD for showing annotations in repository: " + String.valueOf(this.repository), e);
                return;
            }
            info = BlameOperation.computeRevisions(this.repository, currentHead, this.path, (IProgressMonitor)progress.newChild(2));
        }
        if (info == null) {
            return;
        }
        if (this.shell.isDisposed()) {
            return;
        }
        if (this.fileRevision != null) {
            this.storage = this.fileRevision.getStorage((IProgressMonitor)progress.newChild(1));
        } else {
            progress.worked(1);
        }
        ObjectId headId = currentHead;
        this.shell.getDisplay().asyncExec(() -> this.openEditor(info, headId));
    }

    private static RevisionInformation computeRevisions(Repository repo, ObjectId start, String path, IProgressMonitor monitor) {
        BlameResult result;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        RevisionInformation info = new RevisionInformation();
        BlameCommand command = new BlameCommand(repo).setFollowFileRenames(true).setFilePath(path).setStartCommit((AnyObjectId)start);
        if (Activator.getDefault().getPreferenceStore().getBoolean("Blame_IgnoreWhitespace")) {
            command.setTextComparator(RawTextComparator.WS_IGNORE_ALL);
        }
        try {
            result = command.call();
        }
        catch (Exception e1) {
            Activator.error(e1.getMessage(), e1);
            return null;
        }
        progress.worked(1);
        if (result == null) {
            return null;
        }
        HashMap<RevCommit, BlameRevision> revisions = new HashMap<RevCommit, BlameRevision>();
        int lineCount = result.getResultContents().size();
        BlameRevision previous = null;
        int i = 0;
        while (i < lineCount) {
            RevCommit commit = result.getSourceCommit(i);
            String sourcePath = result.getSourcePath(i);
            if (commit == null) {
                if (previous != null) {
                    previous.register();
                    previous = null;
                }
            } else {
                BlameRevision revision = (BlameRevision)((Object)revisions.get(commit));
                if (revision == null) {
                    revision = new BlameRevision();
                    revision.setRepository(repo);
                    revision.setCommit(commit);
                    revision.setSourcePath(sourcePath);
                    revisions.put(commit, revision);
                    info.addRevision((Revision)revision);
                }
                revision.addSourceLine(i, result.getSourceLine(i));
                if (previous != null) {
                    if (previous == revision) {
                        previous.addLine();
                    } else {
                        previous.register();
                        previous = revision.reset(i);
                    }
                } else {
                    previous = revision.reset(i);
                }
            }
            ++i;
        }
        if (previous != null) {
            previous.register();
        }
        return info;
    }

    private void openEditor(RevisionInformation info, ObjectId currentHead) {
        IRevisionRulerColumn revisionRuler;
        AbstractDecoratedTextEditor editorPart;
        block13: {
            try {
                if (this.storage instanceof IFile) {
                    editorPart = RevisionAnnotationController.openEditor((IWorkbenchPage)this.page, (IFile)((IFile)this.storage));
                    break block13;
                }
                FileRevisionEditorInput editorInput = new FileRevisionEditorInput((IFileRevision)this.fileRevision, this.storage);
                editorPart = EgitUiEditorUtils.openEditor(this.page, editorInput);
                if (!(editorPart instanceof MultiPageEditorPart)) break block13;
                MultiPageEditorPart multiEditor = (MultiPageEditorPart)editorPart;
                IEditorPart[] iEditorPartArray = multiEditor.findEditors((IEditorInput)editorInput);
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart part = iEditorPartArray[n2];
                    if (part instanceof AbstractDecoratedTextEditor) {
                        multiEditor.setActiveEditor(part);
                        editorPart = part;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.handleError("Error displaying blame annotations", e, false);
                return;
            }
        }
        if (!(editorPart instanceof AbstractDecoratedTextEditor)) {
            return;
        }
        AbstractDecoratedTextEditor editor = editorPart;
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)Adapters.adapt((Object)editor, IVerticalRulerInfo.class);
        HoverCreators provider = new HoverCreators(rulerInfo);
        IInformationControlCreator creator = provider.hoverCreator();
        IInformationControlCreator presenter = provider.stickyHoverCreator();
        info.setHoverControlCreator(creator);
        info.setInformationPresenterControlCreator(presenter);
        editor.showRevisionInformation(info, QUICKDIFF_PROVIDER_ID);
        if (this.lineNumberToReveal >= 0) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int offset = document.getLineOffset(this.lineNumberToReveal);
                editor.selectAndReveal(offset, 0);
            }
            catch (BadLocationException e) {
                Activator.logError("Error revealing line " + this.lineNumberToReveal, e);
            }
        }
        if ((revisionRuler = (IRevisionRulerColumn)Adapters.adapt((Object)editor, IRevisionRulerColumn.class)) != null) {
            if (revisionRuler instanceof IRevisionRulerColumnExtension) {
                String flagName = this.getClass().getName() + ".selectionHandler";
                Control control = revisionRuler.getControl();
                Object flag = control.getData(flagName);
                if (flag == null) {
                    ((IRevisionRulerColumnExtension)revisionRuler).getRevisionSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)new RevisionSelectionHandler(this.repository, this.path, this.storage));
                    control.setData(flagName, (Object)Boolean.TRUE);
                }
            }
            if (currentHead != null && this.storage instanceof IFile && editor.isChangeInformationShowing()) {
                this.refreshOnHeadChange(editor, revisionRuler, creator, presenter, currentHead);
            }
        }
    }

    private void refreshOnHeadChange(final AbstractDecoratedTextEditor editor, final IRevisionRulerColumn ruler, final IInformationControlCreator hoverPopupCreator, final IInformationControlCreator hoverPresenter, ObjectId currentHead) {
        final String flagName = this.getClass().getName() + ".editorHooks";
        final Control control = ruler.getControl();
        Object flag = control.getData(flagName);
        if (flag != null) {
            return;
        }
        final EditorVisibilityTracker visibilityTracker = new EditorVisibilityTracker((IWorkbenchPart)editor);
        final IPartService partService = (IPartService)editor.getEditorSite().getService(IPartService.class);
        partService.addPartListener((IPartListener2)visibilityTracker);
        RefsChangedListener refsTracker = new RefsChangedListener(currentHead){
            private ObjectId lastHead;
            {
                this.lastHead = objectId;
            }

            public void onRefsChanged(RefsChangedEvent event) {
                try {
                    ObjectId head = event.getRepository().resolve("HEAD");
                    if (head != null && !head.equals((AnyObjectId)this.lastHead)) {
                        this.lastHead = head;
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        if (display != null && !display.isDisposed()) {
                            display.asyncExec(() -> {
                                if (editor.isChangeInformationShowing()) {
                                    visibilityTracker.runWhenVisible(() -> BlameOperation.this.updateBlame(head, ruler, hoverPopupCreator, hoverPresenter, editor));
                                }
                            });
                        }
                    }
                }
                catch (IOException e) {
                    Activator.logError(e.getLocalizedMessage(), e);
                }
            }
        };
        final ListenerHandle handle = this.repository.getListenerList().addRefsChangedListener(refsTracker);
        control.setData(flagName, (Object)Boolean.TRUE);
        final IAction existingAction = editor.getAction("Revision.HideInfo");
        Action newAction = new Action(existingAction.getText()){

            public void run() {
                control.setData(flagName, null);
                handle.remove();
                partService.removePartListener((IPartListener2)visibilityTracker);
                editor.setAction("Revision.HideInfo", existingAction);
                existingAction.run();
            }
        };
        newAction.setToolTipText(existingAction.getToolTipText());
        newAction.setDescription(existingAction.getDescription());
        newAction.setImageDescriptor(existingAction.getImageDescriptor());
        editor.setAction("Revision.HideInfo", (IAction)newAction);
        ruler.getControl().addDisposeListener(event -> {
            handle.remove();
            partService.removePartListener((IPartListener2)visibilityTracker);
        });
    }

    private void updateBlame(final ObjectId head, final IRevisionRulerColumn ruler, final IInformationControlCreator hoverPopupCreator, final IInformationControlCreator hoverPresenter, final AbstractDecoratedTextEditor editor) {
        Job blamer = new Job(UIText.ShowBlameHandler_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RevisionInformation info = BlameOperation.computeRevisions(BlameOperation.this.repository, head, BlameOperation.this.path, monitor);
                    Control control = ruler.getControl();
                    Display display = control.getDisplay();
                    display.asyncExec(() -> {
                        if (!control.isDisposed()) {
                            info.setHoverControlCreator(hoverPopupCreator);
                            info.setInformationPresenterControlCreator(hoverPresenter);
                            if (editor.isChangeInformationShowing()) {
                                editor.showRevisionInformation(info, QUICKDIFF_PROVIDER_ID);
                            }
                        }
                    });
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (SWTException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (RuntimeException e) {
                    IStatus iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.BLAME == family || super.belongsTo(family);
            }
        };
        blamer.setUser(false);
        blamer.setSystem(true);
        blamer.schedule();
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    static class BlameHistoryPageInput
    extends HistoryPageInput
    implements IAdaptable {
        private final RevCommit commit;

        BlameHistoryPageInput(Repository repository, RevCommit commit, File file) {
            super(repository, new File[]{file});
            this.commit = commit;
        }

        BlameHistoryPageInput(Repository repository, RevCommit commit, IResource file) {
            super(repository, new IResource[]{file});
            this.commit = commit;
        }

        BlameHistoryPageInput(Repository repository, RevCommit commit) {
            super(repository);
            this.commit = commit;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (RevCommit.class == adapter) {
                return adapter.cast(this.commit);
            }
            return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            BlameHistoryPageInput other = (BlameHistoryPageInput)obj;
            return this.fieldsEqual(other) && Objects.equals(this.commit, other.commit);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + Objects.hashCode(this.commit);
        }
    }

    private static class HoverCreators {
        private final IInformationControlCreator nonStickyCreator = parentShell -> new BlameInformationControl(parentShell, rulerInfo){

            @Override
            public Point computeSizeHint() {
                Point size = super.computeSizeHint();
                hoverSize = Geometry.copy((Point)size);
                return size;
            }
        };
        private final IInformationControlCreator stickyCreator = parentShell -> new BlameInformationControl(parentShell, rulerInfo, true){

            public Point computeSizeConstraints(int widthInChars, int heightInChars) {
                Point size = super.computeSizeConstraints(widthInChars, heightInChars);
                if (hoverSize != null) {
                    size = Geometry.max((Point)size, (Point)hoverSize);
                }
                return size;
            }
        };
        private Point hoverSize;

        HoverCreators(IVerticalRulerInfo rulerInfo) {
        }

        public IInformationControlCreator hoverCreator() {
            return this.nonStickyCreator;
        }

        public IInformationControlCreator stickyHoverCreator() {
            return this.stickyCreator;
        }
    }

    private static class RevisionSelectionHandler
    implements ISelectionChangedListener {
        private IFile resourceFile;
        private File nonResourceFile;
        private boolean firstSelectionChange = true;

        private RevisionSelectionHandler(Repository repository, String path, IStorage storage) {
            if (storage instanceof IFile) {
                this.resourceFile = (IFile)storage;
            } else if (!repository.isBare()) {
                this.nonResourceFile = new File(repository.getWorkTree(), path);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.firstSelectionChange) {
                this.firstSelectionChange = false;
                return;
            }
            ISelection selection = event.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (!(first instanceof BlameRevision)) {
                return;
            }
            if (!GitHistoryPage.isLinkingEnabled()) {
                return;
            }
            IHistoryView part = (IHistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.team.ui.GenericHistoryView");
            if (part == null) {
                return;
            }
            BlameRevision revision = (BlameRevision)((Object)first);
            BlameHistoryPageInput input = this.resourceFile != null ? new BlameHistoryPageInput(revision.getRepository(), revision.getCommit(), (IResource)this.resourceFile) : (this.nonResourceFile != null ? new BlameHistoryPageInput(revision.getRepository(), revision.getCommit(), this.nonResourceFile) : new BlameHistoryPageInput(revision.getRepository(), revision.getCommit()));
            IHistoryPage currentPage = part.getHistoryPage();
            if (currentPage instanceof GitHistoryPage && input.baseEquals(currentPage.getInput())) {
                ((GitHistoryPage)currentPage).refresh(revision.getCommit());
            } else {
                part.showHistoryFor((Object)input);
            }
        }
    }
}

