/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ILog;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.terminal.view.ui.IMementoHandler;
import org.eclipse.terminal.view.ui.internal.UIPlugin;
import org.eclipse.terminal.view.ui.internal.view.TerminalsView;
import org.eclipse.terminal.view.ui.launcher.ILauncherDelegate;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class TerminalsViewMementoHandler {
    private final List<CTabItem> saveables = new ArrayList<CTabItem>();

    public void setSaveables(List<CTabItem> saveables) {
        Assert.isNotNull(saveables);
        this.saveables.clear();
        this.saveables.addAll(saveables);
    }

    public void saveState(TerminalsView view, IMemento memento) {
        Assert.isNotNull((Object)view);
        Assert.isNotNull((Object)memento);
        memento = memento.createChild("terminalConnections");
        Assert.isNotNull((Object)memento);
        memento.putString("id", view.getViewSite().getId());
        memento.putString("secondaryId", view.getViewSite().getSecondaryId());
        for (CTabItem item : this.saveables) {
            ITerminalViewControl terminal;
            String encoding;
            Optional mementoHandler;
            Map properties;
            if (item.isDisposed() || (properties = (Map)item.getData("properties")) == null || !(mementoHandler = this.findDelegate(properties).flatMap(this::mementoHandler)).isPresent()) continue;
            IMemento connectionMemento = memento.createChild("connection");
            Assert.isNotNull((Object)connectionMemento);
            String delegateId = (String)properties.get("delegateId");
            connectionMemento.putString("delegateId", delegateId);
            String terminalConnectorId = (String)properties.get("tm.terminal.connector.id");
            if (terminalConnectorId != null) {
                connectionMemento.putString("tm.terminal.connector.id", terminalConnectorId);
            }
            if (properties.get("terminal.forceNew") instanceof Boolean) {
                connectionMemento.putBoolean("terminal.forceNew", ((Boolean)properties.get("terminal.forceNew")).booleanValue());
            }
            String string = encoding = (terminal = (ITerminalViewControl)item.getData()) != null ? terminal.getCharset().name() : null;
            if (encoding == null || "".equals(encoding)) {
                encoding = (String)properties.get("encoding");
            }
            if (encoding != null && !"".equals(encoding)) {
                connectionMemento.putString("encoding", encoding);
            }
            if (terminal != null) {
                encoding = terminal.getCharset().name();
                Optional workingDirectory = terminal.getTerminalConnector().getWorkingDirectory();
                String cwd = workingDirectory.orElse((String)properties.get("process.working_dir"));
                if (cwd != null) {
                    connectionMemento.putString("process.working_dir", cwd);
                }
            }
            ((IMementoHandler)mementoHandler.get()).saveState(connectionMemento, properties);
        }
    }

    protected void restoreState(TerminalsView view, IMemento memento) {
        Assert.isNotNull((Object)view);
        Assert.isNotNull((Object)memento);
        memento = memento.getChild("terminalConnections");
        if (memento != null) {
            IMemento[] connections;
            String id = memento.getString("id");
            String secondaryId = memento.getString("secondaryId");
            if ("null".equals(secondaryId)) {
                secondaryId = null;
            }
            IMemento[] iMementoArray = connections = memento.getChildren("connection");
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento connection = iMementoArray[n2];
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("id", id);
                properties.put("secondaryId", secondaryId);
                properties.put("delegateId", connection.getString("delegateId"));
                properties.put("tm.terminal.connector.id", connection.getString("tm.terminal.connector.id"));
                if (connection.getBoolean("terminal.forceNew") != null) {
                    properties.put("terminal.forceNew", connection.getBoolean("terminal.forceNew"));
                }
                if (connection.getString("encoding") != null) {
                    properties.put("encoding", connection.getString("encoding"));
                }
                if (connection.getString("process.working_dir") != null) {
                    properties.put("process.working_dir", connection.getString("process.working_dir"));
                }
                Optional<ILauncherDelegate> delegate = this.findDelegate(properties);
                delegate.map(d -> (IMementoHandler)d.getAdapter(IMementoHandler.class)).ifPresent(mh -> mh.restoreState(connection, properties));
                delegate.ifPresent(d -> this.executeDelegate((Map<String, Object>)properties, (ILauncherDelegate)d));
                ++n2;
            }
        }
    }

    private Optional<ILauncherDelegate> findDelegate(Map<String, Object> properties) {
        return Optional.of(properties).map(map -> map.get("delegateId")).filter(String.class::isInstance).map(String.class::cast).flatMap(id -> UIPlugin.getLaunchDelegateManager().findLauncherDelegate((String)id, false));
    }

    private void executeDelegate(Map<String, Object> properties, ILauncherDelegate delegate) {
        delegate.execute(properties).whenComplete((r, e) -> {
            if (e != null) {
                ILog.get().error("Error occurred while running delegate to open console", e);
            }
        });
    }

    private Optional<IMementoHandler> mementoHandler(ILauncherDelegate delegate) {
        return Optional.ofNullable((IMementoHandler)delegate.getAdapter(IMementoHandler.class));
    }

    void asyncExec(Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }
}

