/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.lm.reviews.util.ModelReferenceExtractorRegistry;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerElementList;
import org.eclipse.net4j.util.container.IContainer;

public final class ModelReference {
    public static final char SEPARATOR = ':';
    private static final List<String> NO_PROPERTIES = Collections.emptyList();
    private final String data;

    public ModelReference(String data) {
        CheckUtil.checkArg((!StringUtil.isEmpty((String)data) ? 1 : 0) != 0, (String)"data");
        this.data = data;
    }

    public ModelReference(String type, List<String> properties) {
        CheckUtil.checkArg((!StringUtil.isEmpty((String)type) && type.indexOf(58) == -1 ? 1 : 0) != 0, (String)"type");
        StringBuilder builder = new StringBuilder(type);
        if (properties != null) {
            for (String property : properties) {
                builder.append(':');
                builder.append(StringUtil.escape((String)property, (char)':'));
            }
        }
        this.data = builder.toString();
    }

    public String getType() {
        int pos = this.data.indexOf(58);
        if (pos == -1) {
            return this.data;
        }
        return this.data.substring(0, pos);
    }

    public List<String> getProperties() {
        String field;
        int pos = this.data.indexOf(58);
        if (pos == -1) {
            return NO_PROPERTIES;
        }
        ArrayList<String> properties = new ArrayList<String>();
        while (true) {
            int nextPos;
            if ((nextPos = this.data.indexOf(58, ++pos)) == -1) break;
            field = this.data.substring(pos, nextPos);
            properties.add(StringUtil.unescape((String)field, (char)':'));
            pos = nextPos;
        }
        field = this.data.substring(pos);
        properties.add(StringUtil.unescape((String)field, (char)':'));
        return properties;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelReference other = (ModelReference)obj;
        return this.data.equals(other.data);
    }

    public String toString() {
        return this.data;
    }

    public static Builder builder(String type) {
        return new Builder(type);
    }

    public static Builder builder(String type, String ... properties) {
        Builder builder = new Builder(type);
        builder.addAll(Arrays.asList(properties));
        return builder;
    }

    public static final class Builder
    extends ArrayList<String> {
        public static final int NO_MAX_LENGTH = -1;
        private static final long serialVersionUID = 1L;
        private final String type;

        public Builder(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }

        public Builder property(Object property, int maxLength) {
            if (property != null) {
                String str = property.toString();
                if (maxLength > 0 && str.length() > maxLength) {
                    str = str.substring(0, maxLength);
                }
                this.add(str);
            }
            return this;
        }

        public Builder property(Object property) {
            return this.property(property, -1);
        }

        public Builder property(CDOID objectID) {
            StringBuilder builder = new StringBuilder();
            CDOIDUtil.write((StringBuilder)builder, (CDOID)objectID);
            return this.property(builder.toString());
        }

        public Builder property(EObject object) {
            CDOObject cdoObject = CDOUtil.getCDOObject((EObject)object);
            if (cdoObject == null || FSMUtil.isTransient((CDOObject)cdoObject)) {
                return this;
            }
            CDOID objectID = cdoObject.cdoID();
            return this.property(objectID);
        }

        public ModelReference build() {
            return new ModelReference(this.type, this);
        }
    }

    public static interface Extractor
    extends ContainerElementList.Prioritized {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.lm.reviews.modelReferenceExtractors";

        public ModelReference extractModelReference(Object var1);

        public static interface Registry
        extends Extractor,
        IContainer<Extractor> {
            public static final Registry INSTANCE = ModelReferenceExtractorRegistry.INSTANCE;

            public Extractor[] getExtractors();
        }
    }
}

