/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TabbedPropertyTitle
extends Composite {
    private CLabel label;
    private Image image = null;
    private String text = null;
    private static final String BLANK = "";
    private static final String TITLE_FONT = "org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle";
    private final TabbedPropertySheetWidgetFactory factory;

    public TabbedPropertyTitle(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super(parent, 524288);
        this.factory = factory;
        this.addPaintListener(e -> {
            if (this.image == null && (this.text == null || this.text.equals(BLANK))) {
                this.label.setVisible(false);
            } else {
                this.label.setVisible(true);
            }
            this.drawTitleBackground(e);
        });
        factory.getColors().initializeSectionToolBarColors();
        this.setBackground(factory.getColors().getBackground());
        this.setForeground(factory.getColors().getForeground());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 2;
        this.setLayout((Layout)layout);
        if (!JFaceResources.getFontRegistry().hasValueFor(TITLE_FONT)) {
            FontData[] fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData();
            fontData[0].setHeight(fontData[0].getHeight() + 2);
            JFaceResources.getFontRegistry().put(TITLE_FONT, fontData);
        }
        Font font = JFaceResources.getFont((String)TITLE_FONT);
        this.label = factory.createCLabel(this, BLANK);
        this.label.setBackground(new Color[]{factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END"), factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START")}, new int[]{100}, true);
        this.label.setFont(font);
        this.label.setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)data);
    }

    protected void drawTitleBackground(PaintEvent e) {
        Rectangle bounds = this.getClientArea();
        this.label.setBackground(new Color[]{this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END"), this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START")}, new int[]{100}, true);
        Color bg = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color gbg = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        GC gc = e.gc;
        gc.setForeground(bg);
        gc.setBackground(gbg);
        gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
        gc.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        gc.drawLine(bounds.x, bounds.height - 2, bounds.x + bounds.width - 1, bounds.height - 2);
        gc.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        gc.drawLine(bounds.x, bounds.height - 1, bounds.x + bounds.width - 1, bounds.height - 1);
    }

    public void setTitle(String text, Image image) {
        this.text = text;
        this.image = image;
        if (text != null) {
            this.label.setText(text);
        } else {
            this.label.setText(BLANK);
        }
        this.label.setImage(image);
        this.redraw();
    }

    public void setColor(String key, RGBA color) {
        this.factory.getColors().createColor(key, color.rgb);
    }

    public void resetSectionToolBarColors() {
        TabbedPropertySheetWidgetFactory f = new TabbedPropertySheetWidgetFactory();
        FormColors defaultColors = f.getColors();
        defaultColors.initializeSectionToolBarColors();
        FormColors colors = this.factory.getColors();
        colors.createColor("org.eclipse.ui.forms.H_GRADIENT_START", defaultColors.getColor("org.eclipse.ui.forms.H_GRADIENT_START").getRGB());
        colors.createColor("org.eclipse.ui.forms.H_GRADIENT_END", defaultColors.getColor("org.eclipse.ui.forms.H_GRADIENT_END").getRGB());
        colors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", defaultColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1").getRGB());
        colors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", defaultColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2").getRGB());
    }
}

