/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.LEDEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicElementEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicTreeEditPolicy;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LogicTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    public LogicTreeEditPart(Object model) {
        super(model);
    }

    public void activate() {
        super.activate();
        this.getLogicSubpart().addPropertyChangeListener(this);
    }

    protected void createEditPolicies() {
        LogicElementEditPolicy component = this.getModel() instanceof LED ? new LEDEditPolicy() : new LogicElementEditPolicy();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)component);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new LogicTreeEditPolicy());
    }

    public void deactivate() {
        this.getLogicSubpart().removePropertyChangeListener(this);
        super.deactivate();
    }

    protected LogicSubpart getLogicSubpart() {
        return (LogicSubpart)this.getModel();
    }

    protected List<LogicElement> getModelChildren() {
        return Collections.emptyList();
    }

    @Override
    public void propertyChange(PropertyChangeEvent change) {
        if (change.getPropertyName().equals("Children")) {
            Object object = change.getOldValue();
            if (object instanceof Integer) {
                Integer intVal = (Integer)object;
                this.addChild(this.createChild(change.getNewValue()), intVal);
            } else {
                this.removeChild(this.getViewer().getEditPartForModel(change.getOldValue()));
            }
        } else {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        if (this.getWidget() instanceof Tree) {
            return;
        }
        Image image = this.getLogicSubpart().getIcon();
        TreeItem item = (TreeItem)this.getWidget();
        if (image != null) {
            image.setBackground(item.getParent().getBackground());
        }
        this.setWidgetImage(image);
        this.setWidgetText(this.getLogicSubpart().toString());
    }
}

