/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.HideNodeHelper;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.IContainer2;
import org.eclipse.zest.core.widgets.ILabeledFigure;
import org.eclipse.zest.core.widgets.IStyleableFigure;
import org.eclipse.zest.core.widgets.InternalLayoutContext;
import org.eclipse.zest.core.widgets.InternalNodeLayout;
import org.eclipse.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.zest.core.widgets.internal.GraphLabel;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class GraphNode
extends GraphItem {
    public static final int HIGHLIGHT_NONE = 0;
    public static final int HIGHLIGHT_ON = 1;
    private int nodeStyle;
    private List<GraphConnection> sourceConnections;
    private List<GraphConnection> targetConnections;
    private Color foreColor;
    private Color backColor;
    private Color highlightColor;
    private Color borderColor;
    private Color borderHighlightColor;
    private int borderWidth;
    private PrecisionPoint currentLocation;
    protected Dimension size;
    private Font font;
    private boolean cacheLabel;
    private boolean visible = true;
    @Deprecated(since="1.12", forRemoval=true)
    private LayoutEntity layoutEntity;
    protected Graph graph;
    protected IContainer parent;
    protected Object internalNode;
    private boolean selected;
    protected int highlighted = 0;
    private IFigure tooltip;
    protected IFigure nodeFigure;
    private IFigure modelFigure;
    private HideNodeHelper hideNodeHelper;
    private boolean isDisposed = false;
    private boolean hasCustomTooltip;
    static int count = 0;
    private IFigure fishEyeFigure = null;
    private Font fishEyeFont = null;
    private boolean isFisheyeEnabled;
    private InternalNodeLayout layout;

    public GraphNode(IContainer graphModel, int style) {
        this(graphModel, style, (Object)null);
    }

    @Deprecated(since="1.12", forRemoval=true)
    public GraphNode(IContainer graphModel, int style, Object data) {
        this(graphModel, style, "", null, data);
    }

    public GraphNode(IContainer graphModel, int style, IFigure data) {
        this(graphModel, style, "", null, data);
    }

    @Deprecated(since="1.12", forRemoval=true)
    public GraphNode(IContainer graphModel, int style, String text) {
        this(graphModel, style, text, null);
    }

    @Deprecated(since="1.12", forRemoval=true)
    public GraphNode(IContainer graphModel, int style, String text, Object data) {
        this(graphModel, style, text, null, data);
    }

    @Deprecated(since="1.12", forRemoval=true)
    public GraphNode(IContainer graphModel, int style, String text, Image image) {
        this(graphModel, style, text, image, null);
    }

    @Deprecated(since="1.12", forRemoval=true)
    public GraphNode(IContainer graphModel, int style, String text, Image image, Object data) {
        super((Widget)graphModel.getGraph(), style, data);
        IContainer iContainer;
        this.initModel(graphModel, text, image);
        if (this.modelFigure == null) {
            this.initFigure();
        }
        if ((iContainer = this.parent) instanceof IContainer2) {
            IContainer2 parent2 = (IContainer2)iContainer;
            parent2.addNode(this);
        }
        this.parent.getGraph().registerItem(this);
    }

    protected void initFigure() {
        this.modelFigure = this.createFigureForModel();
        if (this.graph.getHideNodesEnabled() && !this.checkStyle(4)) {
            this.nodeFigure = new ContainerFigure();
            this.nodeFigure.add(this.modelFigure);
            this.hideNodeHelper = new HideNodeHelper(this);
            this.nodeFigure.setToolTip(this.modelFigure.getToolTip());
        } else {
            this.nodeFigure = this.modelFigure;
        }
    }

    protected void initModel(IContainer parent, String text, Image image) {
        this.nodeStyle |= parent.getGraph().getNodeStyle();
        this.parent = parent;
        this.sourceConnections = new ArrayList<GraphConnection>();
        this.targetConnections = new ArrayList<GraphConnection>();
        this.foreColor = parent.getGraph().DARK_BLUE;
        this.backColor = parent.getGraph().LIGHT_BLUE;
        this.highlightColor = parent.getGraph().HIGHLIGHT_COLOR;
        this.nodeStyle = 0;
        this.borderColor = ColorConstants.lightGray;
        this.borderHighlightColor = ColorConstants.blue;
        this.borderWidth = 1;
        this.currentLocation = new PrecisionPoint(0, 0);
        this.size = new Dimension(-1, -1);
        this.font = Display.getDefault().getSystemFont();
        this.graph = parent.getGraph();
        this.cacheLabel = false;
        this.setText(text);
        this.layoutEntity = new LayoutGraphNode();
        if (image != null) {
            this.setImage(image);
        }
        if (this.font == null) {
            this.font = Display.getDefault().getSystemFont();
        }
    }

    public String toString() {
        return "GraphModelNode: " + this.getText();
    }

    @Deprecated(since="1.12", forRemoval=true)
    public LayoutEntity getLayoutEntity() {
        return this.layoutEntity;
    }

    @Override
    public void dispose() {
        GraphConnection connection;
        if (this.isFisheyeEnabled) {
            this.fishEye(false, false);
        }
        super.dispose();
        this.isDisposed = true;
        while (!this.getSourceConnections().isEmpty()) {
            connection = this.getSourceConnections().get(0);
            if (!connection.isDisposed()) {
                connection.dispose();
                continue;
            }
            this.removeSourceConnection(connection);
        }
        while (!this.getTargetConnections().isEmpty()) {
            connection = this.getTargetConnections().get(0);
            if (!connection.isDisposed()) {
                connection.dispose();
                continue;
            }
            this.removeTargetConnection(connection);
        }
        this.graph.removeNode(this);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public boolean isSizeFixed() {
        return this.size.width >= 0 || this.size.height >= 0;
    }

    public List<? extends GraphConnection> getSourceConnections() {
        return new ArrayList<GraphConnection>(this.sourceConnections);
    }

    public List<? extends GraphConnection> getTargetConnections() {
        return new ArrayList<GraphConnection>(this.targetConnections);
    }

    Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public Point getLocation() {
        return this.currentLocation;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setLocation(double x, double y) {
        if (this.currentLocation.preciseX() != x || this.currentLocation.preciseY() != y) {
            IContainer iContainer;
            this.currentLocation.setPreciseX(x);
            this.currentLocation.setPreciseY(y);
            this.refreshLocation();
            if (this.getGraphModel().isDynamicLayoutEnabled() && (iContainer = this.parent) instanceof IContainer2) {
                IContainer2 parent2 = (IContainer2)iContainer;
                ((InternalLayoutContext)parent2.getLayoutContext()).fireNodeMovedEvent(this.getLayout());
            }
        }
    }

    public Dimension getSize() {
        if (this.size.height < 0 && this.size.width < 0 && this.modelFigure != null) {
            Dimension modelSize = this.modelFigure.getSize();
            if (this.hideNodeHelper != null) {
                if (modelSize.equals(-1, -1)) {
                    modelSize = this.modelFigure.getPreferredSize();
                }
                modelSize.width += 10;
                modelSize.height += 10;
            }
            return modelSize;
        }
        return this.size.getCopy();
    }

    public Color getForegroundColor() {
        return this.foreColor;
    }

    public void setForegroundColor(Color c) {
        this.foreColor = c;
        this.updateFigureForModel(this.modelFigure);
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setBackgroundColor(Color c) {
        this.backColor = c;
        this.updateFigureForModel(this.modelFigure);
    }

    public void setTooltip(IFigure tooltip) {
        this.hasCustomTooltip = true;
        this.tooltip = tooltip;
        this.updateFigureForModel(this.modelFigure);
    }

    public IFigure getTooltip() {
        return this.tooltip;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.updateFigureForModel(this.modelFigure);
    }

    public void setBorderHighlightColor(Color c) {
        this.borderHighlightColor = c;
        this.updateFigureForModel(this.modelFigure);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
    }

    @Override
    public void highlight() {
        if (this.highlighted == 1) {
            return;
        }
        IFigure iFigure = this.nodeFigure.getParent();
        if (iFigure instanceof ZestRootLayer) {
            ZestRootLayer rootLayer = (ZestRootLayer)iFigure;
            rootLayer.highlightNode(this.nodeFigure);
        }
        this.highlighted = 1;
        this.updateFigureForModel(this.modelFigure);
    }

    @Override
    public void unhighlight() {
        if (this.highlighted == 0) {
            return;
        }
        IFigure iFigure = this.nodeFigure.getParent();
        if (iFigure instanceof ZestRootLayer) {
            ZestRootLayer rootLayer = (ZestRootLayer)iFigure;
            rootLayer.unHighlightNode(this.nodeFigure);
        }
        this.highlighted = 0;
        this.updateFigureForModel(this.modelFigure);
    }

    protected void refreshLocation() {
        Rectangle fishEyeBounds;
        Point loc = this.getLocation();
        Dimension nodeSize = this.getSize();
        Rectangle bounds = new Rectangle(loc, nodeSize);
        if (this.nodeFigure == null || this.nodeFigure.getParent() == null) {
            return;
        }
        if (this.hideNodeHelper != null) {
            this.hideNodeHelper.updateNodeBounds(bounds);
        }
        this.nodeFigure.getParent().setConstraint(this.nodeFigure, (Object)bounds);
        if (this.isFisheyeEnabled && (fishEyeBounds = this.calculateFishEyeBounds()) != null) {
            this.fishEyeFigure.getParent().translateToRelative((Translatable)fishEyeBounds);
            this.fishEyeFigure.getParent().translateFromParent((Translatable)fishEyeBounds);
            this.fishEyeFigure.getParent().setConstraint(this.fishEyeFigure, (Object)fishEyeBounds);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.updateFigureForModel(this.modelFigure);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateFigureForModel(this.modelFigure);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        super.setText(string);
        if (this.nodeFigure != null) {
            this.updateFigureForModel(this.modelFigure);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (this.nodeFigure != null) {
            this.updateFigureForModel(this.modelFigure);
        }
    }

    @Override
    public Graph getGraphModel() {
        return this.graph;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
        this.cacheLabel = (this.nodeStyle & 2) > 0;
        this.updateFigureForModel(this.modelFigure);
    }

    public void setSize(double width, double height) {
        if (width != (double)this.size.width || height != (double)this.size.height) {
            this.size.width = (int)width;
            this.size.height = (int)height;
            this.refreshLocation();
        }
    }

    public Color getBorderHighlightColor() {
        return this.borderHighlightColor;
    }

    public boolean cacheLabel() {
        return this.cacheLabel;
    }

    public void setCacheLabel(boolean cacheLabel) {
        this.cacheLabel = cacheLabel;
    }

    public IFigure getNodeFigure() {
        return this.nodeFigure;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.getNodeFigure().setVisible(visible);
        for (GraphConnection graphConnection : this.getSourceConnections()) {
            graphConnection.setVisible(visible);
        }
        for (GraphConnection graphConnection : this.getTargetConnections()) {
            graphConnection.setVisible(visible);
        }
    }

    public void setModelFigure(IFigure figure) {
        this.modelFigure = figure;
    }

    public IFigure getModelFigure() {
        return this.modelFigure;
    }

    public void setHideNodeHelper(HideNodeHelper hideNodeHelper) {
        this.hideNodeHelper = hideNodeHelper;
    }

    public HideNodeHelper getHideNodeHelper() {
        return this.hideNodeHelper;
    }

    public int getStyle() {
        return super.getStyle() | this.getNodeStyle();
    }

    protected Rectangle getHideContainerBounds() {
        return this.nodeFigure.getBounds();
    }

    protected IFigure fishEye(boolean enable, boolean animate) {
        if (this.isDisposed) {
            return null;
        }
        if (!this.checkStyle(4)) {
            return null;
        }
        if (enable) {
            this.fishEyeFigure = this.createFishEyeFigure();
            Rectangle rectangle = this.calculateFishEyeBounds();
            FontData fontData = Display.getCurrent().getSystemFont().getFontData()[0];
            fontData.setHeight(12);
            this.fishEyeFont = new Font((Device)Display.getCurrent(), fontData);
            this.fishEyeFigure.setFont(this.fishEyeFont);
            if (rectangle == null) {
                return null;
            }
            this.getGraphModel().fishEye(this.nodeFigure, this.fishEyeFigure, rectangle, true);
            if (this.fishEyeFigure != null) {
                this.isFisheyeEnabled = true;
            }
            return this.fishEyeFigure;
        }
        this.getGraphModel().removeFishEye(this.fishEyeFigure, this.nodeFigure, animate);
        if (this.fishEyeFont != null) {
            this.fishEyeFont.dispose();
            this.fishEyeFont = null;
        }
        this.isFisheyeEnabled = false;
        this.getGraphModel().removeFishEye(this.fishEyeFigure, this.nodeFigure, animate);
        return null;
    }

    IContainer getParent() {
        return this.parent;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted > 0;
    }

    void invokeLayoutListeners(LayoutConstraint constraint) {
        this.graph.invokeConstraintAdapters((Object)this, constraint);
    }

    protected void updateFigureForModel(IFigure currentFigure) {
        IFigure newFisheyeFigure;
        IFigure toolTip;
        if (currentFigure == null) {
            return;
        }
        IFigure figure = currentFigure;
        if (figure instanceof ILabeledFigure) {
            ILabeledFigure labeledFigure = (ILabeledFigure)figure;
            if (!this.checkStyle(8) && !labeledFigure.getText().equals(this.getText())) {
                labeledFigure.setText(this.getText());
            }
            if (labeledFigure.getIcon() != this.getImage()) {
                labeledFigure.setIcon(this.getImage());
            }
        }
        if (figure instanceof IStyleableFigure) {
            IStyleableFigure styleableFigure = (IStyleableFigure)figure;
            if (this.highlighted == 1) {
                styleableFigure.setForegroundColor(this.getForegroundColor());
                styleableFigure.setBackgroundColor(this.getHighlightColor());
                styleableFigure.setBorderColor(this.getBorderHighlightColor());
            } else {
                styleableFigure.setForegroundColor(this.getForegroundColor());
                styleableFigure.setBackgroundColor(this.getBackgroundColor());
                styleableFigure.setBorderColor(this.getBorderColor());
            }
            styleableFigure.setBorderWidth(this.getBorderWidth());
            if (figure.getFont() != this.getFont()) {
                figure.setFont(this.getFont());
            }
        }
        if (this.getTooltip() == null && !this.hasCustomTooltip) {
            toolTip = new Label();
            ((Label)toolTip).setText(this.getText());
        } else {
            toolTip = this.getTooltip();
        }
        figure.setToolTip(toolTip);
        this.refreshLocation();
        if (this.isFisheyeEnabled && this.graph.replaceFishFigure(this.fishEyeFigure, newFisheyeFigure = this.createFishEyeFigure())) {
            this.fishEyeFigure = newFisheyeFigure;
        }
    }

    protected IFigure createFigureForModel() {
        GraphNode node = this;
        boolean cacheLabel = this.cacheLabel();
        GraphLabel label = new GraphLabel(node.getText(), node.getImage(), cacheLabel);
        label.setFont(this.font);
        if (this.checkStyle(8)) {
            label.setText("");
        }
        this.updateFigureForModel(label);
        label.addFigureListener(new FigureListener(label){
            private Dimension previousSize;
            {
                this.previousSize = graphLabel.getBounds().getSize();
            }

            public void figureMoved(IFigure source) {
                if (Animation.isAnimating() || GraphNode.this.getLayout().isMinimized()) {
                    return;
                }
                Rectangle newBounds = GraphNode.this.nodeFigure.getBounds();
                if (!newBounds.getSize().equals((Object)this.previousSize)) {
                    this.previousSize = newBounds.getSize();
                    if (GraphNode.this.size.width >= 0 && GraphNode.this.size.height >= 0) {
                        GraphNode.this.size = newBounds.getSize();
                    }
                    GraphNode.this.currentLocation = new PrecisionPoint(GraphNode.this.nodeFigure.getBounds().getTopLeft());
                    IContainer iContainer = GraphNode.this.parent;
                    if (iContainer instanceof IContainer2) {
                        IContainer2 parent2 = (IContainer2)iContainer;
                        ((InternalLayoutContext)parent2.getLayoutContext()).fireNodeResizedEvent(GraphNode.this.getLayout());
                    }
                } else if (GraphNode.this.currentLocation.x != newBounds.x || GraphNode.this.currentLocation.y != newBounds.y) {
                    GraphNode.this.currentLocation = new PrecisionPoint(GraphNode.this.nodeFigure.getBounds().getTopLeft());
                    IContainer iContainer = GraphNode.this.parent;
                    if (iContainer instanceof IContainer2) {
                        IContainer2 parent2 = (IContainer2)iContainer;
                        ((InternalLayoutContext)parent2.getLayoutContext()).fireNodeMovedEvent(GraphNode.this.getLayout());
                    }
                }
            }
        });
        return label;
    }

    private IFigure createFishEyeFigure() {
        GraphNode node = this;
        boolean cacheLabel = this.cacheLabel();
        GraphLabel label = new GraphLabel(node.getText(), node.getImage(), cacheLabel);
        if (!this.checkStyle(8)) {
            label.setText(this.getText());
        }
        label.setIcon(this.getImage());
        if (this.highlighted == 1) {
            label.setForegroundColor(this.getForegroundColor());
            label.setBackgroundColor(this.getHighlightColor());
            label.setBorderColor(this.getBorderHighlightColor());
        } else {
            label.setForegroundColor(this.getForegroundColor());
            label.setBackgroundColor(this.getBackgroundColor());
            label.setBorderColor(this.getBorderColor());
        }
        label.setBorderWidth(this.getBorderWidth());
        label.setFont(this.getFont());
        return label;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    private Rectangle calculateFishEyeBounds() {
        Rectangle rectangle = this.nodeFigure.getBounds().getCopy();
        Dimension newSize = this.fishEyeFigure.getPreferredSize();
        Rectangle currentSize = rectangle.getCopy();
        this.nodeFigure.translateToAbsolute((Translatable)currentSize);
        int expandedH = Math.max((newSize.height - currentSize.height) / 2 + 1, 0);
        int expandedW = Math.max((newSize.width - currentSize.width) / 2 + 1, 0);
        Dimension expandAmount = new Dimension(expandedW, expandedH);
        this.nodeFigure.translateToAbsolute((Translatable)rectangle);
        rectangle.expand(new Insets(expandAmount.height, expandAmount.width, expandAmount.height, expandAmount.width));
        if (expandedH <= 0 && expandedW <= 0) {
            return null;
        }
        return rectangle;
    }

    void addSourceConnection(GraphConnection connection) {
        this.sourceConnections.add(connection);
        if (this.hideNodeHelper != null) {
            this.hideNodeHelper.addHideNodeListener(connection.getDestination().hideNodeHelper.getHideNodesListener());
        }
    }

    void addTargetConnection(GraphConnection connection) {
        this.targetConnections.add(connection);
        if (this.hideNodeHelper != null) {
            this.hideNodeHelper.addHideNodeListener(connection.getSource().hideNodeHelper.getHideNodesListener());
        }
    }

    void removeSourceConnection(GraphConnection connection) {
        this.sourceConnections.remove((Object)connection);
        if (this.hideNodeHelper != null) {
            this.hideNodeHelper.removeHideNodeListener(connection.getDestination().hideNodeHelper.getHideNodesListener());
        }
    }

    void removeTargetConnection(GraphConnection connection) {
        this.targetConnections.remove((Object)connection);
        if (this.hideNodeHelper != null) {
            this.hideNodeHelper.removeHideNodeListener(connection.getSource().hideNodeHelper.getHideNodesListener());
        }
    }

    void setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return;
        }
        if (selected) {
            this.highlight();
        } else {
            this.unhighlight();
        }
        this.selected = selected;
    }

    @Override
    public int getItemType() {
        return 1;
    }

    @Override
    IFigure getFigure() {
        if (this.modelFigure == null) {
            this.initFigure();
        }
        return this.modelFigure;
    }

    void paint() {
    }

    public InternalNodeLayout getLayout() {
        if (this.layout == null) {
            this.layout = new InternalNodeLayout(this);
        }
        return this.layout;
    }

    void applyLayoutChanges() {
        if (this.layout != null) {
            this.layout.applyLayout();
        }
    }

    class LayoutGraphNode
    implements LayoutEntity {
        Object layoutInformation = null;

        LayoutGraphNode() {
        }

        public double getHeightInLayout() {
            return GraphNode.this.getSize().height;
        }

        public Object getLayoutInformation() {
            return this.layoutInformation;
        }

        public String toString() {
            return GraphNode.this.getText();
        }

        public double getWidthInLayout() {
            return GraphNode.this.getSize().width;
        }

        public double getXInLayout() {
            return GraphNode.this.getLocation().x;
        }

        public double getYInLayout() {
            return GraphNode.this.getLocation().y;
        }

        public void populateLayoutConstraint(LayoutConstraint constraint) {
            GraphNode.this.invokeLayoutListeners(constraint);
        }

        public void setLayoutInformation(Object internalEntity) {
            this.layoutInformation = internalEntity;
        }

        public void setLocationInLayout(double x, double y) {
            GraphNode.this.setLocation(x, y);
        }

        public void setSizeInLayout(double width, double height) {
            GraphNode.this.setSize(width, height);
        }

        public int compareTo(Object otherNode) {
            int rv = 0;
            if (otherNode instanceof GraphNode) {
                GraphNode node = (GraphNode)((Object)otherNode);
                if (GraphNode.this.getText() != null) {
                    rv = GraphNode.this.getText().compareTo(node.getText());
                }
            }
            return rv;
        }

        public Object getGraphData() {
            return GraphNode.this;
        }

        public void setGraphData(Object o) {
        }
    }
}

