/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.thumbnail;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ThumbnailExample {
    private static Figure contents;
    private static Shell mainShell;
    private static Shell overviewShell;
    private static Dimension offset;

    static {
        offset = new Dimension();
    }

    public static void main(String[] args) {
        Display display = new Display();
        mainShell = new Shell(display);
        mainShell.setText("Source Shell");
        mainShell.setLayout((Layout)new FillLayout());
        FigureCanvas mainCanvas = new FigureCanvas((Composite)mainShell);
        mainCanvas.setContents((IFigure)ThumbnailExample.getContents());
        overviewShell = new Shell(mainShell, 1310768);
        overviewShell.setText("Overview Shell");
        overviewShell.setLayout((Layout)new FillLayout());
        LightweightSystem overviewLWS = new LightweightSystem((Canvas)overviewShell);
        overviewLWS.setContents((IFigure)ThumbnailExample.createThumbnail(ThumbnailExample.getContents()));
        mainShell.setSize(600, 600);
        mainShell.open();
        overviewShell.setSize(200, 200);
        overviewShell.open();
        while (!mainShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        mainShell.dispose();
        overviewShell.dispose();
    }

    protected static Figure getContents() {
        if (contents == null) {
            contents = ThumbnailExample.createContents();
        }
        return contents;
    }

    private static Figure createContents() {
        Figure contents = new Figure();
        contents.setBorder((Border)new LineBorder());
        contents.setLayoutManager((LayoutManager)new XYLayout());
        RectangleFigure figure1 = new RectangleFigure();
        figure1.setBackgroundColor(ColorConstants.green);
        figure1.setBounds(new Rectangle(50, 50, 200, 200));
        figure1.addMouseListener((MouseListener)new MouseListener.Stub((Figure)figure1){
            private final /* synthetic */ Figure val$figure1;
            {
                this.val$figure1 = figure;
            }

            public void mousePressed(MouseEvent event) {
                offset.setWidth(event.x - this.val$figure1.getLocation().x());
                offset.setHeight(event.y - this.val$figure1.getLocation().y());
            }

            public void mouseReleased(MouseEvent event) {
                offset.setWidth(0);
                offset.setHeight(0);
            }
        });
        figure1.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub((Figure)figure1){
            private final /* synthetic */ Figure val$figure1;
            {
                this.val$figure1 = figure;
            }

            public void mouseDragged(MouseEvent event) {
                Rectangle rect = this.val$figure1.getBounds().getCopy();
                rect.setX(event.x - offset.width());
                rect.setY(event.y - offset.height());
                this.val$figure1.setBounds(rect);
            }
        });
        contents.add((IFigure)figure1);
        RectangleFigure figure2 = new RectangleFigure();
        figure2.setBackgroundColor(ColorConstants.blue);
        figure2.setBounds(new Rectangle(350, 350, 150, 200));
        figure2.addMouseListener((MouseListener)new MouseListener.Stub((Figure)figure2){
            private final /* synthetic */ Figure val$figure2;
            {
                this.val$figure2 = figure;
            }

            public void mousePressed(MouseEvent event) {
                offset.setWidth(event.x - this.val$figure2.getLocation().x());
                offset.setHeight(event.y - this.val$figure2.getLocation().y());
            }

            public void mouseReleased(MouseEvent event) {
                offset.setWidth(0);
                offset.setHeight(0);
            }
        });
        figure2.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub((Figure)figure2){
            private final /* synthetic */ Figure val$figure2;
            {
                this.val$figure2 = figure;
            }

            public void mouseDragged(MouseEvent event) {
                Rectangle rect = this.val$figure2.getBounds().getCopy();
                rect.setX(event.x - offset.width());
                rect.setY(event.y - offset.height());
                this.val$figure2.setBounds(rect);
            }
        });
        contents.add((IFigure)figure2);
        return contents;
    }

    protected static Figure createThumbnail(Figure source) {
        Thumbnail thumbnail = new Thumbnail();
        thumbnail.setBorder((Border)new GroupBoxBorder("Overview Figure"));
        thumbnail.setSource((IFigure)source);
        return thumbnail;
    }
}

