/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class SetConstraintCommand
extends Command {
    private Point newPos;
    private Dimension newSize;
    private Point oldPos;
    private Dimension oldSize;
    private LogicSubpart part;

    public void execute() {
        this.oldSize = this.part.getSize();
        this.oldPos = this.part.getLocation();
        this.redo();
    }

    public String getLabel() {
        if (this.oldSize.equals((Object)this.newSize)) {
            return LogicMessages.SetLocationCommand_Label_Location;
        }
        return LogicMessages.SetLocationCommand_Label_Resize;
    }

    public void redo() {
        this.part.setSize(this.newSize);
        this.part.setLocation(this.newPos);
    }

    public void setLocation(Rectangle r) {
        this.setLocation(r.getLocation());
        this.setSize(r.getSize());
    }

    public void setLocation(Point p) {
        this.newPos = p;
    }

    public void setPart(LogicSubpart part) {
        this.part = part;
    }

    public void setSize(Dimension p) {
        this.newSize = p;
    }

    public void undo() {
        this.part.setSize(this.oldSize);
        this.part.setLocation(this.oldPos);
    }
}

