/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackStateProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallStackProviderStub
extends CallStackStateProvider {
    private static final String ENTRY = "entry";
    private static final String EXIT = "exit";

    public CallStackProviderStub(ITmfTrace trace) {
        super(trace);
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull CallStackStateProvider getNewInstance() {
        return new CallStackProviderStub(this.getTrace());
    }

    protected boolean considerEvent(ITmfEvent event) {
        return true;
    }

    protected @Nullable ITmfStateValue functionEntry(ITmfEvent event) {
        ITmfEventField field;
        String name = event.getName();
        if (ENTRY.equals(name) && (field = event.getContent().getField(new String[]{"op"})) != null) {
            return TmfStateValue.newValueString((String)((String)field.getValue()));
        }
        return null;
    }

    protected @Nullable ITmfStateValue functionExit(ITmfEvent event) {
        ITmfEventField field;
        String name = event.getName();
        if (EXIT.equals(name) && (field = event.getContent().getField(new String[]{"op"})) != null) {
            return TmfStateValue.newValueString((String)((String)field.getValue()));
        }
        return null;
    }

    protected int getProcessId(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{"pid"});
        if (field != null) {
            return Integer.parseInt((String)field.getValue());
        }
        return -1;
    }

    protected long getThreadId(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{"tid"});
        if (field != null) {
            return Integer.parseInt((String)field.getValue());
        }
        return -1L;
    }

    protected void eventHandle(ITmfEvent event) {
        if (!this.considerEvent(event)) {
            return;
        }
        ITmfEventField phField = event.getContent().getField(new String[]{"ph"});
        if (phField != null && "i".equals(phField.getValue())) {
            this.handleInstant(event);
            return;
        }
        super.eventHandle(event);
    }

    private void handleInstant(@NonNull ITmfEvent event) {
        super.addMarker(event);
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        Object contents = event.getContent().getFieldValue(String.class, new String[]{"name"});
        String toStore = contents != null ? contents.toString() : "";
        String processName = this.getProcessName(event);
        int processId = this.getProcessId(event);
        if (processName == null) {
            processName = processId == -1 ? "UNKNOWN" : Integer.toString(processId);
        }
        int processQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Processes", processName});
        ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueInt((int)processId), processQuark);
        String threadName = this.getThreadName(event);
        long threadId = this.getThreadId(event);
        if (threadName == null) {
            threadName = Long.toString(threadId);
        }
        int threadQuark = ss.getQuarkRelativeAndAdd(processQuark, new String[]{threadName});
        ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)threadId), threadQuark);
        int callStackQuark = ss.getQuarkRelativeAndAdd(threadQuark, new String[]{"Markers"});
        ss.pushAttribute(timestamp, (Object)toStore, callStackQuark);
    }
}

