/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.scope.LexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;

public abstract class Declaration
implements IDeclaration {
    private @Nullable String fRole;

    @Override
    public ILexicalScope getPath(IDefinitionScope definitionScope, @NonNull String fieldName) {
        ILexicalScope parentPath;
        if (definitionScope != null && (parentPath = definitionScope.getScopePath()) != null) {
            ILexicalScope myScope = parentPath.getChild(fieldName);
            if (myScope == null) {
                myScope = new LexicalScope(parentPath, fieldName);
            }
            return myScope;
        }
        ILexicalScope child = ILexicalScope.ROOT.getChild(fieldName);
        if (child != null) {
            return child;
        }
        return new LexicalScope(ILexicalScope.ROOT, fieldName);
    }

    protected final void alignRead(BitBuffer input) throws CTFException {
        long mask = this.getAlignment() - 1L;
        long pos = input.position();
        if ((pos & mask) == 0L) {
            return;
        }
        pos = pos + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        input.position(pos);
    }

    @Override
    public String getRole() {
        return this.fRole;
    }

    @Override
    public void setRole(String role) {
        this.fRole = role;
    }
}

