/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.debug.ui.launchview.internal.model.ILaunchModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectContainerModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectFavoriteContainerModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectModel;
import org.eclipse.debug.ui.launchview.services.ILaunchObjectProvider;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true)
public class LaunchViewModel
implements ILaunchModel {
    public Set<ILaunchObjectProvider> providers = new TreeSet<ILaunchObjectProvider>((a, b) -> {
        int x = Integer.compare(b.getPriority(), a.getPriority());
        if (x == 0) {
            x = a.getClass().getName().compareTo(b.getClass().getName());
        }
        return x;
    });
    private static LaunchViewModel service;
    private final List<Runnable> updateListeners = new ArrayList<Runnable>();
    private final Runnable providerUpdateListener = this::fireUpdate;

    public Set<ILaunchObjectProvider> getProviders() {
        return this.providers;
    }

    @Override
    public LaunchObjectContainerModel getModel() {
        LaunchObjectContainerModel root = new LaunchObjectContainerModel();
        Set allObjects = this.providers.stream().map(ILaunchObjectProvider::getLaunchObjects).flatMap(o -> o.stream().map(LaunchObjectModel::new)).collect(Collectors.toCollection(TreeSet::new));
        LaunchObjectFavoriteContainerModel favorites = new LaunchObjectFavoriteContainerModel();
        root.addChild(favorites);
        allObjects.stream().map(o -> o.getObject().getType()).distinct().map(LaunchObjectContainerModel::new).forEach(root::addChild);
        allObjects.stream().forEach(m -> {
            LaunchObjectContainerModel container = root.getContainerFor((LaunchObjectModel)m);
            if (container == null) {
                return;
            }
            container.addChild((LaunchObjectModel)m);
            if (m.getObject() != null && m.getObject().isFavorite()) {
                favorites.addChild((LaunchObjectModel)m);
            }
        });
        return root;
    }

    @Reference(service=ILaunchObjectProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addLaunchObjectProvider(ILaunchObjectProvider svc) {
        this.providers.add(svc);
        svc.addUpdateListener(this.providerUpdateListener);
        this.fireUpdate();
    }

    public void removeLaunchObjectProvider(ILaunchObjectProvider svc) {
        this.providers.remove(svc);
        svc.removeUpdateListener(this.providerUpdateListener);
        this.fireUpdate();
    }

    @Reference(service=IWorkbench.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="unsetWorkbench")
    public void setWorkbench(IWorkbench svc) {
    }

    public void unsetWorkbench(IWorkbench svc) {
    }

    @Activate
    public void activate() {
        service = this;
    }

    @Deactivate
    public void deactivate() {
        service = null;
    }

    public void addUpdateListener(Runnable r) {
        this.updateListeners.add(r);
    }

    public void removeUpdateListener(Runnable r) {
        this.updateListeners.remove(r);
    }

    private void fireUpdate() {
        this.updateListeners.forEach(Runnable::run);
    }

    public static LaunchViewModel getService() {
        return service;
    }
}

