/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.coff.Coff64;
import org.eclipse.cdt.utils.coff.PE64;
import org.eclipse.cdt.utils.coff.parser.GNUPESymbol64;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject64;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GNUPEBinaryObject64
extends PEBinaryObject64 {
    private Addr2line autoDisposeAddr2line;
    private Addr2line symbolLoadingAddr2line;
    private CPPFilt symbolLoadingCPPFilt;
    long starttime;

    public GNUPEBinaryObject64(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, header);
    }

    public GNUPEBinaryObject64(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    @Override
    public InputStream getContents() throws IOException {
        InputStream stream = null;
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            try {
                byte[] contents = objdump.getOutput();
                stream = new ByteArrayInputStream(contents);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public Addr2line getAddr2line(boolean autodisposing) {
        if (!autodisposing) {
            return this.getAddr2line();
        }
        if (this.autoDisposeAddr2line == null) {
            this.autoDisposeAddr2line = this.getAddr2line();
            if (this.autoDisposeAddr2line != null) {
                this.starttime = System.currentTimeMillis();
                Runnable worker = () -> {
                    long diff = System.currentTimeMillis() - this.starttime;
                    while (diff < 10000L) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        diff = System.currentTimeMillis() - this.starttime;
                    }
                    this.stopAddr2Line();
                };
                new Thread(worker, "Addr2line Reaper").start();
            }
        } else {
            this.starttime = System.currentTimeMillis();
        }
        return this.autoDisposeAddr2line;
    }

    private synchronized void stopAddr2Line() {
        if (this.autoDisposeAddr2line != null) {
            this.autoDisposeAddr2line.dispose();
        }
        this.autoDisposeAddr2line = null;
    }

    private Addr2line getAddr2line() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getAddr2line(this.getPath());
        }
        return null;
    }

    protected CPPFilt getCPPFilt() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getCPPFilt();
        }
        return null;
    }

    protected Objdump getObjdump() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getObjdump(this.getPath());
        }
        return null;
    }

    @Override
    protected void loadSymbols(PE64 pe) throws IOException {
        this.symbolLoadingAddr2line = this.getAddr2line(false);
        this.symbolLoadingCPPFilt = this.getCPPFilt();
        try {
            super.loadSymbols(pe);
        }
        finally {
            if (this.symbolLoadingAddr2line != null) {
                this.symbolLoadingAddr2line.dispose();
                this.symbolLoadingAddr2line = null;
            }
            if (this.symbolLoadingCPPFilt != null) {
                this.symbolLoadingCPPFilt.dispose();
                this.symbolLoadingCPPFilt = null;
            }
        }
    }

    @Override
    protected void addSymbols(Coff64.Symbol[] peSyms, byte[] table, List<Symbol> list) {
        Coff64.Symbol[] symbolArray = peSyms;
        int n = peSyms.length;
        int n2 = 0;
        while (n2 < n) {
            Coff64.Symbol element = symbolArray[n2];
            if (element.n_sclass == 2 && element.n_scnum > 0) {
                int type;
                String name = element.toString();
                if (this.symbolLoadingCPPFilt != null) {
                    try {
                        name = this.symbolLoadingCPPFilt.getFunction(name);
                    }
                    catch (IOException e1) {
                        this.symbolLoadingCPPFilt.dispose();
                        this.symbolLoadingCPPFilt = null;
                    }
                }
                Addr32 addr = new Addr32(element.n_value);
                long size = element.getSize();
                int n3 = type = element.isFunction() ? 1 : 2;
                if (this.symbolLoadingAddr2line != null) {
                    try {
                        String filename = this.symbolLoadingAddr2line.getFileName(addr);
                        Path file = filename != null && !filename.equals("??") ? new Path(filename) : Path.EMPTY;
                        int startLine = this.symbolLoadingAddr2line.getLineNumber(addr);
                        int endLine = this.symbolLoadingAddr2line.getLineNumber(addr.add(size - 1L));
                        list.add(new GNUPESymbol64(this, name, type, (IAddress)addr, size, (IPath)file, startLine, endLine));
                    }
                    catch (IOException e) {
                        this.symbolLoadingAddr2line.dispose();
                        this.symbolLoadingAddr2line = null;
                        list.add(new GNUPESymbol64(this, name, type, (IAddress)addr, size));
                    }
                } else {
                    list.add(new GNUPESymbol64(this, name, type, (IAddress)addr, size));
                }
            }
            ++n2;
        }
    }
}

