/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.treemap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;

public class TreeMapStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    private final ReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final TreeMultimap<Long, E> fStartTimesIndex;
    private volatile int fSize = 0;
    private volatile long fStart = Long.MAX_VALUE;
    private volatile long fEnd = Long.MIN_VALUE;
    private transient @Nullable Iterable<E> fLastSnapshot = null;

    public TreeMapStore() {
        this.fStartTimesIndex = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparingLong(IHTInterval::getEnd).thenComparing(Function.identity()));
    }

    @Override
    public Iterator<E> iterator() {
        this.fLock.readLock().lock();
        try {
            ImmutableList lastSnapshot = this.fLastSnapshot;
            if (lastSnapshot == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf((Collection)this.fStartTimesIndex.values());
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.writeLock().lock();
        try {
            boolean put = this.fStartTimesIndex.put((Object)val.getStart(), val);
            if (put) {
                ++this.fSize;
                this.fStart = Math.min(this.fStart, val.getStart());
                this.fEnd = Math.max(this.fEnd, val.getEnd());
                this.fLastSnapshot = null;
            }
            boolean bl = put;
            return bl;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.fSize;
    }

    @Override
    public boolean isEmpty() {
        return this.fSize == 0;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (o == null || !(o instanceof ISegment)) {
            return false;
        }
        this.fLock.readLock().lock();
        try {
            ISegment seg = (ISegment)o;
            boolean bl = this.fStartTimesIndex.get((Object)seg.getStart()).contains(o);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStartTimesIndex.values().containsAll(c);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.fLock.readLock().lock();
        try {
            Object[] objectArray = this.fStartTimesIndex.values().toArray();
            return objectArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fLock.readLock().lock();
        try {
            T[] TArray = this.fStartTimesIndex.values().toArray(a);
            return TArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.writeLock().lock();
        try {
            boolean changed = false;
            for (ISegment elem : c) {
                if (!this.add((E)elem)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.fLock.writeLock().lock();
        try {
            this.fSize = 0;
            this.fStart = Long.MAX_VALUE;
            this.fEnd = Long.MIN_VALUE;
            this.fStartTimesIndex.clear();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    @Override
    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.readLock().lock();
        try {
            if (start <= this.fStart && end >= this.fEnd) {
                if (this.fLastSnapshot == null) {
                    this.fLastSnapshot = ImmutableList.copyOf((Collection)this.fStartTimesIndex.values());
                }
                Iterable iterable = (Iterable)NonNullUtils.checkNotNull(this.fLastSnapshot);
                return iterable;
            }
            ArrayList<BasicSegment> iterable = new ArrayList<BasicSegment>();
            BasicSegment fromElement = new BasicSegment(Long.MIN_VALUE, start);
            for (Collection col : this.fStartTimesIndex.asMap().headMap(end, true).values()) {
                NavigableSet nav = (NavigableSet)col;
                iterable.addAll(nav.tailSet(fromElement, true));
            }
            ArrayList<BasicSegment> arrayList = iterable;
            return arrayList;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    @Override
    public void dispose() {
        this.clear();
    }
}

